/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{ץ֥}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__process_local_h__
#define __HOS__process_local_h__


#include "process.h"
#include "system/handle/handleobj_local.h"
#include "system/sysapi/sysapi.h"


/* ץ֥ȴܥ饹 */
typedef struct c_process
{
	C_HANDLEOBJ			HandleObj;						/**< ϥɥ륪֥ȤѾ */

	HANDLE				*pHandleList;					/**< ͭϥɥΥꥹ(λ˳) */
	
	struct c_process	*pNext;							/*< Υץ */
	struct c_process	*pPrev;							/*< Υץ */
	
	SYSPRC_HANDLE		hPrc;							/**< ץϥɥ */
	SYSEVT_HANDLE		hEvt;							/**< Ԥ碌ѥ٥ */
	int					iExitCode;						/**< λ */
	void				*pStack;						/**< åΰΥ */

	char				*pszCommandLine;				/**< ¹Ԥ륳ޥ */
	char				*pszCurrentDir;					/**< ȥǥ쥯ȥ */

	int					(*pfncEntry)(VPARAM Param);		/**< ưɥ쥹 */
	VPARAM				Param;							/**< 桼ѥ᡼ */
	C_ASSOC				*pEnv;							/**< Ķѿ */

	void				(*pfncSignalProc)(int iSignal);	/**< ʥץ */
	int					iSignal;						/**< 桼ѥ᡼ */

	MEMSIZE				StackSize;						/**< å */
	int					Priority;						/**< ץͥ */
	char				SysMode;						/**< ƥ⡼ */
	char				Exit;							/**< λե饰 */
	HANDLE				hTerminal;						/**< ߥʥ */
	HANDLE				hConIn;							/**< 󥽡 */
	HANDLE				hConOut;						/**< 󥽡 */
	HANDLE				hStdIn;							/**< ɸ */
	HANDLE				hStdOut;						/**< ɸ */
	HANDLE				hStdErr;						/**< ɸ२顼 */
} C_PROCESS;


#ifdef __cplusplus
extern "C" {
#endif

PROCESS_ERR Process_Constructor(C_PROCESS *self, const T_HANDLEOBJ_METHODS *pMethods, const T_PROCESS_CREATE_INF *pInf);		/**< 󥹥ȥ饯 */
void        Process_Destructor(C_PROCESS *self);																				/**< ǥȥ饯 */

PROCESS_ERR Process_Attach(C_PROCESS *self, const T_HANDLEOBJ_METHODS *pMethods, const T_PROCESS_CREATE_INF *pInf);				/**< ¸ץ򥢥å */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__process_local_h__ */



/* end of file */
