/** 
 *  Hyper Operating System  Application Framework
 *
 * @file process_setenvstring.c
 * @brief %jp{Ķѿ}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "process_local.h"



/** Ķѿ */
void Process_SetEnvString(HANDLE hProcess, const char *pszKey, const char *pszValue)
{
	C_PROCESS *self;
	
	/* ̵꤬иߤΥץȤ */
	if ( hProcess == HANDLE_NULL )
	{
		hProcess = Process_GetCurrentHandle();
	}
	
	/* ϥɥ򥭥㥹 */
	self = (C_PROCESS *)hProcess;
	
	/* ΰ褬̵ */
	if ( self->pEnv == NULL )
	{
		self->pEnv = Assoc_CreateEx(SysMem_GetMemHeap());
		if ( self->pEnv == NULL )
		{
			return;
		}
	}
	
	/* ѥ᡼ */
	Assoc_Set(self->pEnv, pszKey, pszValue, strlen(pszValue)+1);
}


/* end of file */
