/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


/* ITRONޥͥȤơ¸ϤΥ⥸塼Ƕϱä */
/* 륷ƥ⡼(ǥХɥ饤Фʤ)Τߤ˵API */
/* 桼⡼APIӺͽ */


#ifndef __HOS__sysapi_h__
#define __HOS__sysapi_h__


#include "system/type/type.h"
#include "library/container/memheap/memheap.h"


/* ץϥɥ(ƥ) */
#define SYSPRC_HANDLE_NULL			(0)
typedef void* SYSPRC_HANDLE;

/* ߥ塼ƥåϥɥ(ƥ) */
#define SYSMTX_HANDLE_NULL			(0)
typedef void* SYSMTX_HANDLE;

/* ٥ȥϥɥ(ƥ) */
#define SYSEVT_HANDLE_NULL			(0)
typedef void* SYSEVT_HANDLE;

/* ߥӥ롼ϥɥ(ƥ) */
#define SYSISR_HANDLE_NULL			(0)
typedef void* SYSISR_HANDLE;

/* ץ°(ƥ) */
#define	SYSPRC_ATTR_NORMAL			0x00

/* ٥°(ƥ) */
#define	SYSEVT_ATTR_NORMAL			0x00
#define	SYSEVT_ATTR_AUTOCLEAR		0x01

/* ߥ塼ƥå°(ƥ) */
#define	SYSMTX_ATTR_NORMAL			0x00

/*  */
typedef _HOS_UINT64					SYSTIM_SYSTIME;
typedef _HOS_UINT64					SYSTIM_CPUTIME;


#ifdef __cplusplus
extern "C" {
#endif

/*  */
void           SysApi_Initialize(void *pMem, MEMSIZE MemSize, MEMSIZE MemAlign, void *pIoMem, MEMSIZE IoMemSize, MEMSIZE IoMemAlign);
																			/**< ƥν */

/* ƥּ */
int            SysCtx_IsIsr(void);											/**< ISRƥȤɤĴ٤(ƥ) */

/* ƥå */
void           SysLoc_Lock(void);											/**< ƥΤΥå(ƥ) */
void           SysLoc_Unlock(void);											/**< ƥΤΥå(ƥ) */

/* ƥѥAPI */
void          *SysMem_Alloc(MEMSIZE Size);									/**< γ(ƥ) */
void          *SysMem_ReAlloc(void *pMem, MEMSIZE Size);					/**< κƳ(ƥ) */
void           SysMem_Free(void *pMem);										/**< ֵ(ƥ) */
MEMSIZE        SysMem_GetSize(void *pMem);									/**< Υ(ƥ) */
C_MEMHEAP      *SysMem_GetMemHeap(void);									/**< ꥤ󥿡եμ(ƥ) */


/* ƥѳAPI */
void           SysInt_Enable(int iIntNum);									/**< ߵ(ƥ) */
void           SysInt_Disable(int iIntNum);									/**< ߶ػ(ƥ) */
void           SysInt_Clear(int iIntNum);									/**< װꥢ(ƥ) */
void           SysInt_SetIntTime(int iIntNum, SYSTIM_CPUTIME Time);			/**< ߷¬ޤ */
SYSTIM_CPUTIME SysInt_GetIntTime(int iIntNum);								/**< ߷¬ޤ */

/* ߥӥ롼API */
SYSISR_HANDLE  SysIsr_Create(int iIntNum, void (*pfncIsr)(VPARAM Param), VPARAM Param);
void           SysIsr_Delete(SYSISR_HANDLE hIsr);

/* ƥѥץAPI */
SYSPRC_HANDLE  SysPrc_Create(void (*pfncEntry)(void), VPARAM Param, void *pStack, MEMSIZE StackSize, int Priority, int iAttr);
																			/**< ץ(ƥ) */
void           SysPrc_Delete(SYSPRC_HANDLE hPrc);							/**< ץ(ƥ) */
VPARAM         SysPrc_GetParam(SYSPRC_HANDLE hPrc);							/**< ץΥѥ᡼(ƥ) */

void           SysPrc_Start(SYSPRC_HANDLE hPrc);							/**< ץ(ƥ) */
void           SysPrc_Terminate(SYSPRC_HANDLE hPrc);						/**< ץλ(ƥ) */
void           SysPrc_Suspend(SYSPRC_HANDLE hPrc);							/**< ץ(ƥ) */			
void           SysPrc_Resume(SYSPRC_HANDLE hPrc);							/**< ץ߲(ƥ) */	
void           SysPrc_SendSignal(SYSPRC_HANDLE hPrc);						/**< ץؤΥʥ(ƥ) */
void           SysPrc_SetSignalHandler(SYSPRC_HANDLE hPrc, void (*pfncHanler)(void));
																			/**< ץؤΥʥϥɥϿ(ƥ) */
SYSPRC_HANDLE  SysPrc_GetCurrentHandle(void);								/**< ߤΥץμ(ƥ) */
void           SysPrc_SetExecTime(SYSPRC_HANDLE hPrc, SYSTIM_CPUTIME Time);	/**< ץ¹Իַ¬ޤ */
SYSTIM_CPUTIME SysPrc_GetExecTime(SYSPRC_HANDLE hPrc);						/**< ץ¹Իַ¬ޤ */

/* ƥѥߥ塼ƥåAPI */
SYSMTX_HANDLE  SysMtx_Create(int iAttr);									/**< ߥ塼ƥå(ƥ) */
void           SysMtx_Delete(SYSMTX_HANDLE hMtx);							/**< ߥ塼ƥå(ƥ) */
int            SysMtx_PolingLock(SYSMTX_HANDLE hMtx);						/**< ߥ塼ƥåݡ󥰥å(ƥ) */
void           SysMtx_Lock(SYSMTX_HANDLE hMtx);								/**< ߥ塼ƥåå(ƥ) */
void           SysMtx_Unlock(SYSMTX_HANDLE hMtx);							/**< ߥ塼ƥåå(ƥ) */
int            SysMtx_RefStatus(SYSMTX_HANDLE hMtx);						/**< ߥ塼ƥåξ֤(ƥ) */

/* ƥѥ٥API */
SYSEVT_HANDLE  SysEvt_Create(int iAttr);									/**< ٥(ƥ) */
void           SysEvt_Delete(SYSEVT_HANDLE hEvt);							/**< ٥Ⱥ(ƥ) */
void           SysEvt_Wait(SYSEVT_HANDLE hEvt);								/**< ٥Ԥ(ƥ) */
void           SysEvt_Set(SYSEVT_HANDLE hEvt);								/**< ٥ȥå(ƥ) */
void           SysEvt_Clear(SYSEVT_HANDLE hEvt);							/**< ٥ȥꥢ(ƥ) */
int            SysEvt_RefStatus(SYSEVT_HANDLE hEvt);						/**< ٥Ȥξ֤(ƥ) */

/* ִ */
void           SysTim_Signal(unsigned long ulTic);							/**< ƥॿ˥ƥåͿ(ƥ) */
void           SysTim_Wait(unsigned long ulTime);							/**< Ԥ(ƥ) */
TIME           SysTim_GetCurrentTime(void);									/**< ߤλ(ƥ) */
SYSTIM_SYSTIME SysTim_GetSystemTime(void);									/**< ߤΥƥ(ƥ) */
unsigned long  SysTim_SysTimeToSecond(SYSTIM_SYSTIME SysTime);				/**< ƥä˴(ƥ) */
unsigned long  SysTim_SysTimeToNanosecond(SYSTIM_SYSTIME SysTime);			/**< ƥʥä˴(ƥ) */
SYSTIM_CPUTIME SysTim_GetCpuTime(void);										/**< ߤCPU(ƥ) */
unsigned long  SysTim_CpuTimeToSecond(SYSTIM_CPUTIME CpuTime);				/**< CPUä˴(ƥ) */
unsigned long  SysTim_CpuTimeToNanosecond(SYSTIM_CPUTIME CpuTime);			/**< CPUʥä˴(ƥ) */


/* I/O */
#ifdef __HOSAPLFW_IOMAPEDIO
/* I/OޥåץI/O  */
unsigned char  SysIo_InPortB(void *Port);									/**< I/OݡȤХ(8bit) */
unsigned short SysIo_InPortH(void *Port);									/**< I/OݡȤϡե(16bit) */
unsigned long  SysIo_InPortW(void *Port);									/**< I/OݡȤ(32bit) */
unsigned char  SysIo_OutPortB(void *Port, unsigned char Data);				/**< I/OݡȤإХ(8bit) */
unsigned short SysIo_OutPortH(void *Port, unsigned short Data);				/**< I/OݡȤإϡե(16bit) */
unsigned long  SysIo_OutPortW(void *Port, unsigned long Data);				/**< I/OݡȤإ(32bit) */
unsigned char  SysIo_AndPortB(void *Port, unsigned char Data);				/**< I/OݡȤХ(8bit)ñ̤ */
unsigned short SysIo_AndPortH(void *Port, unsigned short Data); 		 	/**< I/OݡȤϡե(16bit)ñ̤ */
unsigned long  SysIo_AndPortW(void *Port, unsigned long Data);  		 	/**< I/OݡȤ(32bit)ñ̤ */
unsigned char  SysIo_OrPortB(void *Port, unsigned char Data);				/**< I/OݡȤХ(8bit)ñ̤ */
unsigned short SysIo_OrPortH(void *Port, unsigned short Data);				/**< I/OݡȤϡե(16bit)ñ̤ */
unsigned long  SysIo_OrPortW(void *Port, unsigned long Data);				/**< I/OݡȤ(32bit)ñ̤ */
unsigned char  SysIo_XorPortB(void *Port, unsigned char Data);				/**< I/OݡȤХ(8bit)ñ̤¾Ū */
unsigned short SysIo_XorPortH(void *Port, unsigned short Data);				/**< I/OݡȤϡե(16bit)ñ̤¾Ū */
unsigned long  SysIo_XorPortW(void *Port, unsigned long Data);				/**< I/OݡȤ(32bit)ñ̤¾Ū */
#else
/* ޥåץI/O */
#define        SysIo_InPortB(Port)			(*(volatile unsigned char *)(Port))
#define        SysIo_InPortH(Port)			(*(volatile unsigned short *)(Port))
#define        SysIo_InPortW(Port)			(*(volatile unsigned long *)(Port))
#define        SysIo_OutPortB(Port, Data)	(*(volatile unsigned char *)(Port) = (unsigned char)(Data))
#define        SysIo_OutPortH(Port, Data)	(*(volatile unsigned short *)(Port) = (unsigned short)(Data))
#define        SysIo_OutPortW(Port, Data)	(*(volatile unsigned long *)(Port) = (unsigned long)(Data))
#define        SysIo_AndPortB(Port, Data)	(*(volatile unsigned char *)(Port) &= (unsigned char)(Data))
#define        SysIo_AndPortH(Port, Data)	(*(volatile unsigned short *)(Port) &= (unsigned short)(Data))
#define        SysIo_AndPortW(Port, Data)	(*(volatile unsigned long *)(Port) &= (unsigned long)(Data))
#define        SysIo_OrPortB(Port, Data)	(*(volatile unsigned char *)(Port) |= (unsigned char)(Data))
#define        SysIo_OrPortH(Port, Data)	(*(volatile unsigned short *)(Port) |= (unsigned short)(Data))
#define        SysIo_OrPortW(Port, Data)	(*(volatile unsigned long *)(Port) |= (unsigned long)(Data))
#define        SysIo_XorPortB(Port, Data)	(*(volatile unsigned char *)(Port) ^= (unsigned char)(Data))
#define        SysIo_XorPortH(Port, Data)	(*(volatile unsigned short *)(Port) ^= (unsigned short)(Data))
#define        SysIo_XorPortW(Port, Data)	(*(volatile unsigned long *)(Port) ^= (unsigned long)(Data))
#endif

/* ƥˤäƤꥢɥ쥹ϰϤˤDMAȤʤäꡢ󥭥åΰ褬ɬפʤΤߤ */
void          *SysIo_AllocIoMem(MEMSIZE Size);								/**< I/OŬγ(ƥ) */
void           SysIo_FreeIoMem(void *pMem);									/**< I/OŬֵ(ƥ) */


#ifdef __cplusplus
}
#endif


#endif

