/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI HOS-V4a }
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__sysapi_local_h__
#define __HOS__sysapi_local_h__


#include "kernel.h"
#include "sysapi.h"
#include "system/sysmem/sysmemheap_local.h"
#include "library/container/valmemheap/valmemheap_local.h"

#define _HOS_SYSPAI_USEMTX


/* HOS-V4a ѿλ() */
extern const ID		_kernel_max_tskid;
extern const INTNO	_kernel_min_intno;
extern const INTNO	_kernel_max_intno;


/* ץͭ */
typedef struct t_sysprc_inf
{
	VPARAM				Param;					/* ץͭѥ᡼ */
	SYSTIM_CPUTIME		ExecTime;				/* ץ¹Իַ¬ */
} T_SYSPRC_INF;


/* ISRͭ */
typedef struct t_sysint_inf
{
	SYSTIM_CPUTIME		ExecTime;				/* INT¹Իַ¬ */
} T_SYSINT_INF;

extern C_SYSMEMHEAP		SysMem_SysMemHeap;		/* ƥ */
extern C_VALMEMHEAP		SysMem_ValMemHeap;		/* ƥҡץ */
extern SYSMTX_HANDLE	SysIo_hMtx;				/* I/Oѥҡץѥߥ塼ƥå */
extern C_VALMEMHEAP		*SysIo_pValMemHeap;		/* I/Oѥҡץ */
extern T_SYSPRC_INF		*SysPrc_InfTbl;			/* ץѥơ֥ */
extern T_SYSINT_INF		*SysInt_InfTbl;			/* ISRѥơ֥ */
extern SYSTIM_CPUTIME	SysTim_TimeCounter;		/* ǥեȤΥޥ */



#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__sysapi_local_h__ */


/* end of file */
