/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "sysapi_local.h"



SYSTIM_CPUTIME		SysHos_OldTime;
ID					SysHos_TaskId;


/** ߷¬ޤ */
void SysInt_SetIntTime(int iIntNum, SYSTIM_CPUTIME Time)
{
	if ( SysInt_InfTbl == NULL )
	{
		return;
	}

	if ( iIntNum < _kernel_min_intno || iIntNum > _kernel_max_intno )
	{
		return;
	}

	SysInt_InfTbl[iIntNum - _kernel_min_intno].ExecTime = Time;
}


/** ߷¬ޤ */
SYSTIM_CPUTIME SysInt_GetIntTime(int iIntNum)
{
	if ( SysInt_InfTbl == NULL )
	{
		return 0;
	}

	if ( iIntNum < _kernel_min_intno || iIntNum > _kernel_max_intno )
	{
		return 0;
	}
	
	return SysInt_InfTbl[iIntNum - _kernel_min_intno].ExecTime;
}


/** ץ¹Իַ¬ޤ */
void SysPrc_SetExecTime(SYSPRC_HANDLE hPrc, SYSTIM_CPUTIME Time)
{
	if ( SysPrc_InfTbl == NULL )
	{
		return;
	}
	
	SysPrc_InfTbl[(ID)hPrc].ExecTime = Time;
}


/** ץ¹Իַ¬ޤ */
SYSTIM_CPUTIME SysPrc_GetExecTime(SYSPRC_HANDLE hPrc)
{
	if ( SysPrc_InfTbl == NULL )
	{
		return 0;
	}
	
	return SysPrc_InfTbl[(ID)hPrc].ExecTime;
}


/** %jp{åΥեå} */
void _kernel_tsk_swi(ID tskid_old, ID tskid_new)
{
	SYSTIM_CPUTIME NewTime;
	SYSTIM_CPUTIME PastTime;
	
	/* ߻ */
	NewTime  = SysTim_GetCpuTime();
	PastTime = NewTime - SysHos_OldTime;
	
	/* ¹Ի֤߻ */
	if ( SysPrc_InfTbl != NULL )
	{
		SysPrc_InfTbl[tskid_old].ExecTime += PastTime;
	}
	
	/* ¬ */
	SysHos_OldTime = NewTime;
	SysHos_TaskId  = tskid_new;
}


/** %jp{ߥӥ롼󳫻ϤΥեå} */
void _kernel_isr_sta(INHNO inhno)
{
	SYSTIM_CPUTIME NewTime;
	SYSTIM_CPUTIME PastTime;
	
	/* ߻ */
	NewTime  = SysTim_GetCpuTime();
	PastTime = NewTime - SysHos_OldTime;
	
	/* ¹Ի֤߻ */
	if ( SysPrc_InfTbl != NULL )
	{
		SysPrc_InfTbl[SysHos_TaskId].ExecTime += PastTime;
	}

	/* ¬ */
	SysHos_OldTime = NewTime;	
}


/**< %jp{ߥӥ롼λΥեå} */
void _kernel_isr_end(INTNO intno)
{
	SYSTIM_CPUTIME NewTime;
	SYSTIM_CPUTIME PastTime;
	
	/* ߻ */
	NewTime  = SysTim_GetCpuTime();
	PastTime = NewTime - SysHos_OldTime;
	
	/* ¹Ի֤߻ */
	if ( SysInt_InfTbl != NULL )
	{
		SysInt_InfTbl[intno - _kernel_min_intno].ExecTime += PastTime;
	}
}


/* end of file */
