/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "sysapi_local.h"


/* I/OѥΤγ */
void *SysIo_AllocIoMem(MEMSIZE Size)
{
	void *pMem;

	/* ̾ȷ */
	if ( SysIo_pValMemHeap == NULL )
	{
		return SysMem_Alloc(Size);
	}
	
	/* I/Oΰ褫 */
	SysMtx_Lock(SysIo_hMtx);
	pMem = ValMemHeap_Alloc(SysIo_pValMemHeap, Size);
	SysMtx_Unlock(SysIo_hMtx);
	
	return pMem;
}


/* end of file */
