/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  sysmemheap_alloc.c
 * @brief %jp{ƥҡץ饹}%en{system memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "sysmemheap_local.h"



/** %jp{MemHeap饹 ۴ؿơ֥}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS SysMemHeap_Methods =
	{
		SysMemHeap_Alloc,			/**< γ */
		SysMemHeap_ReAlloc,			/**< κƳ */
		SysMemHeap_Free,			/**< γ */
		SysMemHeap_GetSize,			/**< Υ */
		SysMemHeap_GetAlign,		/**< ꥢ饤Ȥμ */
		SysMemHeap_AlignSize,		/**< 򥢥饤ñ̤˳ĥ */
	};



/** %jp{󥹥ȥ饯} */
void SysMemHeap_Constructor(C_SYSMEMHEAP *self, C_MEMHEAP *pMemHeap)
{
	self->hMtx     = SysMtx_Create(SYSMTX_ATTR_NORMAL);
	self->pMemHeap = pMemHeap;
	
	/* %jp{ƥ饹󥹥ȥ饯} */
	MemHeap_Constructor(&self->MemHeap, &SysMemHeap_Methods);
}


/* end of file */
