/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "system/sysapi/sysapi.h"
#include "system/system/system_local.h"
#include "system/file/file.h"
#include "system/command/command.h"


/* ƥ९饹 */
C_SYSTEM g_System;


static void System_BootProcess(VPARAM Param1, VPARAM Param2);


/* ƥν */
void System_Initialize(const T_SYSTEM_INITIALIZE_INF *pInf)
{
	C_SYSTEM				*self;
	T_PROCESS_CREATE_INF	*pProcessInf;
	
	self = &g_System;

	/* ƥAPIν */
	SysApi_Initialize(pInf->pSysMemBase, pInf->SysMemSize, pInf->SysMemAlign,
							pInf->pIoMemBase, pInf->IoMemSize, pInf->IoMemAlign);
	
	/* ƥ¾ѥߥ塼ƥå */
	self->hMtxSys = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* ƥѿν */
	self->hEvtProc     = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);
	self->iProcHead    = 0;
	self->iProcTail    = 0;
	self->paWhiteBoard = NULL;

	/* ե륷ƥ */
	File_Initialize();
	
	/* ޥɥƥ */
	Command_Initialize();
	
	/* ץѥ */
	pProcessInf = (T_PROCESS_CREATE_INF *)SysMem_Alloc(sizeof(T_PROCESS_CREATE_INF));
	memset(pProcessInf, 0, sizeof(T_PROCESS_CREATE_INF));
	
	/* ƥץεư */
	pProcessInf->pszCommandLine = "[system]";
	pProcessInf->pfncEntry      = System_Process;			/* ưɥ쥹 */
	pProcessInf->Param          = (VPARAM)self;				/* 桼ѥ᡼ */
	pProcessInf->StackSize      = pInf->SystemStackSize;	/* å */
	pProcessInf->Priority       = 1;						/* ץͥ */
	pProcessInf->hTerminal      = HANDLE_NULL;				/* ߥʥ */
	pProcessInf->hConIn         = HANDLE_NULL;				/* 󥽡 */
	pProcessInf->hConOut        = HANDLE_NULL;				/* 󥽡 */
	pProcessInf->hStdIn         = HANDLE_NULL;				/* ɸ */
	pProcessInf->hStdOut        = HANDLE_NULL;				/* ɸ */
	pProcessInf->hStdErr        = HANDLE_NULL;				/* ɸ२顼 */
	pProcessInf->pszCurrentDir  = "/";						/* ȥǥ쥯ȥ */
	Process_Constructor(&self->Process, NULL, pProcessInf);
	
	/* ֡ȥץεư */
	pProcessInf->pszCommandLine = "[boot]";
	pProcessInf->pfncEntry      = pInf->pfncBoot;			/* ưɥ쥹 */
	pProcessInf->Param          = pInf->BootParam;			/* 桼ѥ᡼ */
	pProcessInf->StackSize      = pInf->BootStackSize;		/* å */
	pProcessInf->Priority       = PROCESS_PRIORITY_NORMAL;	/* ץͥ */
	pProcessInf->hTerminal      = HANDLE_NULL;				/* ߥʥ */
	pProcessInf->hConIn         = HANDLE_NULL;				/* 󥽡 */
	pProcessInf->hConOut        = HANDLE_NULL;				/* 󥽡 */
	pProcessInf->hStdIn         = HANDLE_NULL;				/* ɸ */
	pProcessInf->hStdOut        = HANDLE_NULL;				/* ɸ */
	pProcessInf->hStdErr        = HANDLE_NULL;				/* ɸ२顼 */
	pProcessInf->pszCurrentDir  = "/";						/* ȥǥ쥯ȥ */
	System_RequestProc(System_BootProcess, (VPARAM)self, (VPARAM)pProcessInf);
}


/* ֡ȥץ򥷥ƥץλҥץȤƳ */
void System_BootProcess(VPARAM Param1, VPARAM Param2)
{
	C_SYSTEM				*self;
	T_PROCESS_CREATE_INF	*pProcessInf;

	self        = (C_SYSTEM *)Param1;
	pProcessInf = (T_PROCESS_CREATE_INF *)Param2;
	
	/* ֡ȥץ򥷥ƥץλҥץȤƳ */
	self->hBootProcess = Process_CreateEx(pProcessInf);
	
	/* ץѥ곫 */
	SysMem_Free(pProcessInf);
}



/* end of file */
