/** 
 * $PROJECT_NAME$
 *
 * @file  xxxxdrv_constructor.c
 * @brief %jp{$OBJNAME_JP$ ֥Ⱥ}%en{$OBJNAME_EN$  delete object}
 *
 * $COPYRIGHT$
 */


#include "xxxxdrv_local.h"



/** %jp{۴ؿơ֥}%en{virtual functions table} */
const T_DRVOBJ_METHODS XxxxDrv_Methods = 
	{
		{ XxxxDrv_Delete },
		XxxxDrv_Open,
		XxxxDrv_Close,
		XxxxDrv_IoControl,
		XxxxDrv_Seek,
		XxxxDrv_Read,
		XxxxDrv_Write,
		XxxxDrv_Flush,
	};



/** 󥹥ȥ饯 */
FILE_ERR XxxxDrv_Constructor(C_XXXXDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum)
{
	FILE_ERR	ErrCode;
	
	/* ۴ؿơ֥ */
	if ( pMethods == NULL )
	{
		pMethods = &XxxxDrv_Methods;
	}
		
	/* ƥ饹󥹥ȥ饯ƤӽФ */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		return ErrCode;
	}
	
	/* ѿ */
	self->pRegBase    = pRegBase;
	self->iIntNum     = iIntNum;
	self->iOpenCount  = 0;

	
	/* ߽Ͽ */
	self->hIsr = SysIsr_Create(self->iIntNum, XxxxDrv_Isr, (VPARAM)self);
	if ( self->hIsr == SYSISR_HANDLE_NULL )
	{
		SyncDrv_Destructor(&self->SyncDrv);
		return FILE_ERR_NG;		
	}
	
	return FILE_ERR_OK;
}


/* end of file */
