/**
 *  Hyper Operating System V4 Advance Configurator
 *
 * @file  hos4cfg.cpp
 * @brief %jp{ᥤ롼}%en{main}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "readcfg.h"
#include "defercd.h"
#include "read.h"
#include "analyze.h"
#include "apiinc.h"
#include "dpcque.h"
#include "idlstk.h"
#include "intstk.h"
#include "knlheap.h"
#include "maxtpri.h"
#include "cretsk.h"
#include "deftex.h"
#include "cresem.h"
#include "creflg.h"
#include "credtq.h"
#include "crembx.h"
#include "cremtx.h"
#include "crembf.h"
#include "crempf.h"
#include "timtic.h"
#include "crecyc.h"
#include "crealm.h"
#include "definh.h"
#include "attisr.h"
#include "attini.h"
#include "defexc.h"


#define DEFAULT_INPUTFILE		"system.i"
#define DEFAULT_IDFILE			"kernel_id.h"
#define DEFAULT_CFGFILE			"kernel_cfg.c"


int  ReadConfigFile(FILE* fpConfig);	// ե졼եɤ߹
void WriteIdFile(FILE* fp);				// ID إåե
void WriteCfgFile(FILE* fp);			// C 쥽
void PrintUsage(void);


CApiInclude    g_ApiInclude;
CApiKernelHeap g_ApiKernelHeap;
CApiDpcQue     g_ApiDpcQue;
CApiIdleStack  g_ApiIdleStack;
CApiMaxTpri    g_ApiMaxTpri;
CApiIntStack   g_IntStack;
CApiCreTsk     g_ApiCreTsk;
CApiDefTex     g_ApiDefTex;
CApiCreSem     g_ApiCreSem;
CApiCreFlg     g_ApiCreFlg;
CApiCreDtq     g_ApiCreDtq;
CApiCreMbx     g_ApiCreMbx;
CApiCreMtx     g_ApiCreMtx;
CApiCreMbf     g_ApiCreMbf;
CApiCreMpf     g_ApiCreMpf;
CApiTimTic     g_ApiTimTic;
CApiCreCyc     g_ApiCreCyc;
CApiCreAlm     g_ApiCreAlm;
CApiDefInh     g_ApiDefInh;
CApiAttIsr     g_ApiAttIsr;
CApiAttIni     g_ApiAttIni;
CApiDefExc     g_ApiDefExc;

static const char *s_szPhysicalInputFile  = NULL;
static const char *s_szIdFile             = DEFAULT_IDFILE;
static const char *s_szCfgFile            = DEFAULT_CFGFILE;

// APIꥹ
static CApiDef* g_ApiList[] =
	{
		&g_ApiInclude,
		&g_ApiKernelHeap,
		&g_ApiDpcQue,
		&g_ApiIdleStack,
		&g_IntStack,
		&g_ApiCreTsk,
//		&g_ApiDefTex,
		&g_ApiCreSem,
		&g_ApiCreFlg,
		&g_ApiCreDtq,
		&g_ApiCreMbx,
		&g_ApiCreMtx,
//		&g_ApiCreMbf,
		&g_ApiCreMpf,
		&g_ApiTimTic,
		&g_ApiCreCyc,
//		&g_ApiCreAlm,
		&g_ApiDefInh,
		&g_ApiAttIsr,
		&g_ApiAttIni,
//		&g_ApiDefExc,
	};

#define API_COUNT	((int)(sizeof(g_ApiList) / sizeof(CApiDef*)))		// APIĿ




// ᥤؿ
int main(int argc, char *argv[])
{
	FILE* fpInput;
	FILE* fpCfg;
	FILE* fpId;
	int  iErr;
	int  i;

	// ޥɥ饤
	for ( i = 1; i < argc; i++ )
	{
		if ( strcmp(argv[i], "-c") == 0 )
		{
			i++;
			if ( i >= argc )
			{
				fprintf(stderr, "option error \"-c\"\n");
				PrintUsage();
				return 1;
			}
			s_szCfgFile = argv[i];
		}
		else if ( strcmp(argv[i], "-i") == 0 )
		{
			i++;
			if ( i >= argc )
			{
				fprintf(stderr, "option error \"-i\"\n");
				PrintUsage();
				return 1;
			}
			s_szIdFile = argv[i];
		}
		else if ( strcmp(argv[i], "-help") == 0 )
		{
			PrintUsage();
			return 0;
		}
		else if ( argv[i][0] == '-' && argv[i][1] != '\0' )
		{
			fprintf(stderr, "unknown option \"%s\"\n", argv[i]);
			PrintUsage();
			return 1;
		}
		else
		{
			if ( s_szPhysicalInputFile != NULL )
			{
				fprintf(stderr, "too many input files\n");
				PrintUsage();
				return 1;
			}
			s_szPhysicalInputFile = argv[i];
		}
	}

	// ϥեάΥǥե
	if ( s_szPhysicalInputFile == NULL )
	{
		s_szPhysicalInputFile = DEFAULT_INPUTFILE;
	}

	// ϥե륪ץ
	if ( strcmp(s_szPhysicalInputFile, "-") == 0) {
		s_szPhysicalInputFile = "stdin";
		fpInput = stdin;
	}
	else if ( (fpInput = fopen(s_szPhysicalInputFile, "r")) == NULL )
	{
               fprintf(stderr, "could not open file \"%s\"\n", s_szPhysicalInputFile);
		return 1;
	}
	
	// ե졼եɤ߹
	iErr = ReadConfigFile(fpInput) != 0;
	fclose(fpInput);
	if ( iErr != 0 )
	{
		return 1;
	}

	// ưIDֹ
	for ( i = 0; i < API_COUNT; i++ )
	{
		g_ApiList[i]->AutoId();
	}

	// ID ե륪ץ
	if ( (fpId = fopen(s_szIdFile, "w")) == NULL )
	{
               fprintf(stderr, "could not open file \"%s\"\n", s_szIdFile);
		return 1;
	}

	WriteIdFile(fpId);

	fclose(fpId);


	// Cfgե륪ץ
	if ( (fpCfg = fopen(s_szCfgFile, "w")) == NULL )
	{
               fprintf(stderr, "could not open file \"%s\"\n", s_szCfgFile);
		return 1;
	}

	WriteCfgFile(fpCfg);

	fclose(fpCfg);

	return 0;
}


// ե졼եɤ߹
int ReadConfigFile(FILE* fpConfig)
{
	char szState[READ_MAX_STATE];
	char szApiName[READ_MAX_STATE];
	char szParams[READ_MAX_STATE];
	int  iErr;
	int  i;

	CRead read(fpConfig, s_szPhysicalInputFile);	// ɤ߽Ф֥

	// ɤ߹
	while (	(iErr = read.ReadState(szState)) != CFG_ERR_COMPLETE )
	{
		// ɤ߹ߥ顼å
		if ( iErr != CFG_ERR_OK )
		{
			fprintf(stderr, "%s line(%d) : %s\n",
				read.GetLogicalInputFile(),
				read.GetLogicalLineNum(), GetErrMessage(iErr));
			return 1;
		}
		
		// ʸ
		iErr = CAnalyze::SplitState(szApiName, szParams, szState);
		if ( iErr != CFG_ERR_OK )
		{
			fprintf(stderr, "%s line(%d) : %s\n",
				read.GetLogicalInputFile(),
				read.GetLogicalLineNum(), GetErrMessage(iErr));
			return 1;
		}
		CAnalyze::SpaceCut(szApiName);
		CAnalyze::SpaceCut(szParams);

		// API
		iErr = CFG_ERR_SYNTAX;
		for ( i = 0; i < API_COUNT; i++ )
		{
			iErr = g_ApiList[i]->AnalyzeApi(szApiName, szParams);
			if ( iErr != CFG_ERR_NOPROC )
			{
				break;
			}
		}
		if ( iErr != CFG_ERR_OK )
		{
			if ( iErr != CFG_ERR_NOPROC )
			{
				fprintf(stderr, "%s line(%d) : %s\n",
						read.GetLogicalInputFile(),
						read.GetLogicalLineNum(), GetErrMessage(iErr));
				return 1;
			}
			else
			{
				fprintf(stderr, "%s line(%d) : Warning!  Ignore unknown API(%s)\n",
						read.GetLogicalInputFile(),
						read.GetLogicalLineNum(),
						szApiName);
			}
		}
	}

	return 0;
}


// IDإåե
void WriteIdFile(FILE* fp)
{
	int i;

	/* إå */
	fputs(
		"/* ------------------------------------------------------------------------ */\n"
		"/*  HOS-V4a  kernel configuration                                           */\n"
		"/*    kernel object ID definition                                           */\n"
		"/*                                                                          */\n"
		"/* ------------------------------------------------------------------------ */\n"
		"\n\n"
		"#ifndef __KERNEL__kernel_id_h__\n"
		"#define __KERNEL__kernel_id_h__\n"
		"\n"
		, fp);

	// ID ե
	for ( i = 0; i < API_COUNT; i++ )
	{
		g_ApiList[i]->WriteId(fp);
	}

	// եå
	fputs(
		"\n\n\n"
		"#endif\t/* __KERNEL__kernel_id_h__ */\n"
		"\n\n"
		"/* ------------------------------------------------------------------------ */\n"
		"/*  End of file                                                             */\n"
		"/* ------------------------------------------------------------------------ */\n"
		, fp);
}


// C 쥽
void WriteCfgFile(FILE* fp)
{
	int i;

	/* إå */
	fprintf(
		fp,
		"/* ------------------------------------------------------------------------ */\n"
		"/*  HOS-V4a  kernel configuration                                           */\n"
		"/*    kernel object create and initialize                                   */\n"
		"/*                                                                          */\n"
		"/* ------------------------------------------------------------------------ */\n"
		"\n\n");

	fprintf(fp, "#include \"kernel.h\"\n");
	fprintf(fp, "#include \"arch/proc/%s/procatr.h\"\n", _KERNEL_PROCATR_INC_PATH);
	fprintf(fp, "#include \"arch/proc/%s/proc.h\"\n",    _KERNEL_PROCATR_INC_PATH);
	fprintf(fp, "#include \"arch/irc/%s/ircatr.h\"\n",   _KERNEL_IRCATR_INC_PATH);
	fprintf(fp, "#include \"arch/irc/%s/irc.h\"\n",      _KERNEL_IRCATR_INC_PATH);
	fprintf(fp, "#include \"config/cfgknl.h\"\n");
	fprintf(fp, "#include \"parser/parsknl.h\"\n");
	fprintf(fp, "#include \"core/objid.h\"\n");
	fprintf(fp, "#include \"core/objhdl.h\"\n");
	fprintf(fp, "#include \"object/tskobj.h\"\n");
	fprintf(fp, "#include \"object/semobj.h\"\n");
	fprintf(fp, "#include \"object/flgobj.h\"\n");
	fprintf(fp, "#include \"object/dtqobj.h\"\n");
	fprintf(fp, "#include \"object/mbxobj.h\"\n");
	fprintf(fp, "#include \"object/mtxobj.h\"\n");
	fprintf(fp, "#include \"object/mpfobj.h\"\n");
	fprintf(fp, "#include \"object/inhobj.h\"\n");
	fprintf(fp, "#include \"object/isrobj.h\"\n");
	fprintf(fp, "#include \"object/cycobj.h\"\n");
	
//	fprintf(fp, "#include \"%s\"\n", s_szIdFile);
	fprintf(fp, "#include \"kernel_id.h\"\n");
	
	
	// ID ե
	for ( i = 0; i < API_COUNT; i++ )
	{
		g_ApiList[i]->WriteCfgDef(fp);
	}

	// ؿȽ
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*          initialize functions              */\n"
		"/* ------------------------------------------ */\n",
		fp);

	// ؿ
	fputs(
		"\n/* object initialize */\n"
		"void _kernel_cfg_ini(void)\n"
		"{\n",
		fp);
	for ( i = 0; i < API_COUNT; i++ )
	{
		g_ApiList[i]->WriteCfgIni(fp);
	}
	fputs("}\n", fp);

	// ؿ
	fputs(
		"\n/* start up */\n"
		"void _kernel_cfg_sta(void)\n"
		"{\n",
		fp);
	for ( i = 0; i < API_COUNT; i++ )
	{
		g_ApiList[i]->WriteCfgStart(fp);
	}
	fputs("}\n", fp);

	// եå
	fputs(
		"\n\n"
		"/* ------------------------------------------------------------------------ */\n"
		"/*  End of file                                                             */\n"
		"/* ------------------------------------------------------------------------ */\n"
		, fp);
}

// Ȥɽ
void PrintUsage(void)
{
       fprintf(stderr,
               "usage: hos4cfg [options] [input-file]\n"
               "options are:\n"
               "   -i FILE    specify auto-assginment headerfile (default: " DEFAULT_IDFILE ")\n"
               "   -c FILE    specify kernel configuration file  (default: " DEFAULT_CFGFILE ")\n"
               "   -help      show this help\n"
               "\n"
               "input-file (default: " DEFAULT_INPUTFILE ")\n");
}


// end of file
