// ---------------------------------------------------------------------------
//  Hyper Operating System V4  ե졼                           
//    HOS_IDL_STK API ν                                                  
//                                                                            
//                                    Copyright (C) 1998-2006 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "idlstk.h"
#include "analyze.h"
#include "readcfg.h"


#define SYSSTK_STKSZ		0
#define SYSSTK_STK			1


// 󥹥ȥ饯
CApiIdleStack::CApiIdleStack()
{
	// ѥ᡼ʸ
	m_iParamSyntax[0] = 0;		// ñȥѥ᡼
	m_iParams = 2;
}


// ǥȥ饯
CApiIdleStack::~CApiIdleStack()
{
}


// ưIDֹ
int CApiIdleStack::AutoId(void)
{
	return CFG_ERR_OK;
}


// APIβ
int CApiIdleStack::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "KERNEL_SYS_STK") == 0 )
	{
		if ( m_iObjs > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		return AddParams(pszParams);
	}

	return CFG_ERR_NOPROC;
}


// cfgե񤭽Ф
void  CApiIdleStack::WriteCfgDef(FILE* fp)
{
	const char* pszSize;
	const char* pszStack;

	// Ƚ
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*               system stack                 */\n"
		"/* ------------------------------------------ */\n\n"
		, fp);

	// ѥ᡼ɤ߽Ф
	if ( m_iObjs > 0 )
	{
		pszSize  = m_pParamPacks[0]->GetParam(SYSSTK_STKSZ);
		pszStack = m_pParamPacks[0]->GetParam(SYSSTK_STK);
	}
	else
	{
		pszSize  = "256";
		pszStack = "NULL";		// ̵꤬NULL(ư)
	}

	// ɥ롼ѥå
	if ( strcmp(pszStack, "NULL") == 0 )
	{
		fprintf(
			fp,
			"VP         _kernel_sys_stkblk[((%s) + sizeof(VP) - 1) / sizeof(VP)];\t/* system stack block*/\n\n",
			pszSize);
	}
}


// cfgե뵯ư񤭽Ф
void  CApiIdleStack::WriteCfgIni(FILE* fp)
{
	const char* pszSize;
	const char* pszStack;

	// ѥ᡼ɤ߽Ф
	if ( m_iObjs > 0 )
	{
		pszSize  = m_pParamPacks[0]->GetParam(SYSSTK_STKSZ);
		pszStack = m_pParamPacks[0]->GetParam(SYSSTK_STK);
	}
	else
	{
		pszSize  = "256";
		pszStack = "NULL";		// ̵꤬NULL(ư)
	}
	
	if ( strcmp(pszStack, "NULL") == 0 )
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_SYSSTK((SIZE)sizeof(_kernel_sys_stkblk), (VP)(_kernel_sys_stkblk));\n");
	}
	else
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_SYSSTK((SIZE)(%s), (VP)(%s));\n",
			pszSize, pszStack);
	}

}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2003 by Project HOS                                    
// ---------------------------------------------------------------------------
