# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for Z80
#
# Copyright (C) 1998-2006 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{Ƽ}{setting}
# --------------------------------------

# %jp{åȥ饤֥̾}%en{target library name}
TARGET ?= libhosv4a


# %jp{ƥ}%en{architecture}
ARCH_NAME ?= z80
ARCH_PROC ?= 8080/z80
ARCH_IRC  ?= none
ARCH_CC   ?= sdcc


# %jp{ǥ쥯ȥ}%en{directories}
TOP_DIR           = ../../../../..
KERNEL_DIR        = $(TOP_DIR)/kernel
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
INC_PROC_DIR      = $(KERNEL_DIR)/include/arch/proc/$(ARCH_PROC)
INC_IRC_DIR       = $(KERNEL_DIR)/include/arch/irc/$(ARCH_IRC)
SRC_PROC_DIR      = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)
SRC_PROC_ASM_DIR  = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)/$(ARCH_CC)
SRC_IRC_DIR       = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)
SRC_IRC_ASM_DIR   = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)/$(ARCH_CC)
CFGRTR_DIR        = $(TOP_DIR)/cfgrtr/build/gcc


# %jp{ե졼}%en{kernel configurator}
CFGRTR = h4acfg-$(ARCH_NAME)


# %jp{ͥ}%en{kernel flag}
KERNEL = Yes


# %jp{ɹ}%en{common setting}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ѥ}%en{add source directories}
INC_DIRS += $(INC_PROC_DIR) $(INC_IRC_DIR)
SRC_DIRS += $(SRC_PROC_DIR) $(SRC_PROC_DIR) $(SRC_PROC_ASM_DIR) $(SRC_IRC_DIR) $(SRC_IRC_ASM_DIR)


# %jp{ץե饰}%en{option flags}
AFLAGS  = -mgbz80
CFLAGS  = -mgbz80 --std-sdcc89
ARFLAGS = 


# %jp{ѥ¸ɹ}%en{compiler dependent definitions}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc

# %jp{饤֥ɹ}%en{definitions for library}
include $(KERNEL_MAKINC_DIR)/maklib_d.inc




# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------

# %jp{֥եɲ}%en{assembry sources}
ASRCS += 


# %jp{Cեɲ}%en{C sources}
CSRCS += 


# %jp{ͥ붦̥ɲ}%en{kernel common sources}
include $(KERNEL_MAKINC_DIR)/knlsrc.inc




# --------------------------------------
#  %jp{롼}%en{rules}
# --------------------------------------

# %jp{ALL}%en{all}
.PHONY : all
all: makelib_all
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC)

# %jp{꡼}%en{clean}
.PHONY : clean
clean: makelib_clean
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC) clean
	$(RM) -f *.lst

# %jp{¸ط}%en{make depend}
.PHONY : depend
depend: makelib_depend


# %jp{饤֥ɹ}%en{rules for library}
include $(KERNEL_MAKINC_DIR)/maklib_r.inc

# %jp{ѥ¸Υ롼ɹ}%en{rules for compiler}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_r.inc




# --------------------------------------
#  %jp{¸ط}%en{dependency}
# --------------------------------------

# %jp{ͥ¸طɹ}
include $(KERNEL_MAKINC_DIR)/knldep.inc



# end of file
