# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for ATMEL AT91 series
#
# Copyright (C) 1998-2007 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# å̾
TARGET    ?= libhosv4a


# ǥ쥯ȥ
HOSV4A_DIR        = ../../../../..
KERNEL_DIR        = $(HOSV4A_DIR)/kernel
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
OBJS_DIR          = objs_$(TARGET)


# %jp{ͥ}
KERNEL = Yes


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ƥ}
ARCH_PROC ?= arm/arm_v4t
ARCH_IRC  ?= arm/at91
ARCH_CC   ?= armcc


# %jp{ƥѥ}
INC_PROC_DIR    = $(KERNEL_DIR)/include/arch/proc/$(ARCH_PROC)
INC_IRC_DIR     = $(KERNEL_DIR)/include/arch/irc/$(ARCH_IRC)
SRC_PROC_DIR    = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)
SRC_PROC_CC_DIR = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)/$(ARCH_CC)
SRC_IRC_DIR     = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)
SRC_IRC_CC_DIR  = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)/$(ARCH_CC)


# %jp{ѥ}
INC_DIRS += $(INC_PROC_DIR) $(INC_IRC_DIR)
SRC_DIRS += $(SRC_PROC_DIR) $(SRC_PROC_DIR) $(SRC_PROC_CC_DIR) $(SRC_IRC_DIR) $(SRC_IRC_CC_DIR)


# %jp{ץե饰}
AFLAGS  += --cpu=ARM7TDMI --apcs=inter --thumb
CFLAGS  += --cpu=ARM7TDMI --apcs=inter --thumb
ARFLAGS += 


# %jp{ե졼}
CFGRTR_DIR = $(HOSV4A_DIR)/cfgrtr/build/gcc
CFGRTR     = h4acfg-at91


# %jp{ѥ¸ɹ}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc



# Cեɲ
CSRCS += $(SRC_PROC_DIR)/val_int.c			\
         $(SRC_IRC_DIR)/kini_irc.c			\
         $(SRC_IRC_DIR)/kexe_irc.c			\
         $(SRC_IRC_DIR)/ena_int.c			\
         $(SRC_IRC_DIR)/dis_int.c			\
         $(SRC_IRC_DIR)/vclr_int.c


# ֥եɲ
ASRCS += $(SRC_PROC_CC_DIR)/kcre_ctx.s		\
         $(SRC_PROC_CC_DIR)/kdis_int.s		\
         $(SRC_PROC_CC_DIR)/kena_int.s		\
         $(SRC_PROC_CC_DIR)/kirq_hdr.s		\
         $(SRC_PROC_CC_DIR)/kfiq_hdr.s		\
         $(SRC_PROC_CC_DIR)/krst_ctx.s		\
         $(SRC_PROC_CC_DIR)/kswi_ctx.s		\
         $(SRC_PROC_CC_DIR)/kwai_int.s



# ͥ붦̥ɲ
include $(KERNEL_MAKINC_DIR)/knlsrc.inc



# %jp{ALL}
.PHONY : all
all: makelib_all
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC)


# %jp{꡼}
.PHONY : clean
clean: makelib_clean
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC) clean
	$(RM) -f *.lst


# %jp{¸ط}
.PHONY : depend
depend: makelib_depend



# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makelib.inc


# %jp{ѥ¸롼ɹ}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_r.inc


# %jp{ͥ¸طɹ}
include $(KERNEL_MAKINC_DIR)/knldep.inc



# end of file
