# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#
#  Copyright (C) 1998-2007 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------




# --------------------------------------
#  %jp{ץŸ}%en{options}
# --------------------------------------


# %jp{C쥤󥯥롼ɥѥץ}%en{C-compiler include path}
ifneq ($(INC_DIRS),)
CFLAGS_INC = $(patsubst %,-I%,$(INC_DIRS))
endif


# %jp{Cޥץ}%en{C-compiler define macros}
ifneq ($(C_DEFS),)
CFLAGS_DEF = $(patsubst %,-D%,$(C_DEFS))
endif


# %jp{֥쥤󥯥롼ɥѥץ}%en{Assembler include path}
ifneq ($(INC_DIRS),)
AFLAGS_INC =
endif


# %jp{֥ޥץ}%en{Assembler define macros}
ifneq ($(A_DEFS),)
AFLAGS_DEF =
endif


# %jp{ץ}{Options marged}
CFLAGS += $(CFLAGS_INC) $(CFLAGS_DEF)
AFLAGS += $(AFLAGS_INC) $(AFLAGS_DEF)



# --------------------------------------
#  %jp롼}%en{Rules}
# --------------------------------------

# %jp{¹ԥե}%en{Executable file}
$(TARGET_EXE): $(OBJS) $(LIBS)
	$(CMD_LINK) $(LNFLAGS) -o $(TARGET_EXE) $(OBJS) $(LIBS)


# %jp{ȥSե}%en{Motorola S format file}
$(TARGET_MOT): $(TARGET_EXE)
	$(CMD_OBJCNV) --m32 --output $(TARGET_MOT) $(TARGET_EXE)


# %jp{ƥHEXե}%en{Intel HEX format file}
$(TARGET_HEX): $(TARGET_EXE)
	$(CMD_OBJCNV) --i32 --output $(TARGET_HEX) $(TARGET_EXE)


# %jp{ץ졼Хʥե}%en{Plain Binary}
$(TARGET_BIN): $(TARGET_EXE)
	$(CMD_OBJCNV) --bin --output $(TARGET_BIN) $(TARGET_EXE)


# %jp{饤֥}%en{Library}
$(TARGET_LIB): $(OBJS)
	$(CMD_LIBR) $(ARFLAGS) --create $(TARGET_LIB) $(OBJS)


# %jp{Cѥ}%en{C Compile}
$(OBJS_DIR)/%.$(EXT_OBJ) :: %.$(EXT_C)
	$(CMD_CC) $(CFLAGS) -c $< -o $@


# %jp{֥}%en{Assemble}
$(OBJS_DIR)/%.$(EXT_OBJ) :: %.$(EXT_ASM)
	$(CMD_ASM) $(AFLAGS) $< -o $@


# %jp{祳ѥ}%en{batch cmpile}
batch_c:
	$(CMD_CC) $(CFLAGS) -c $(CSRCS)
	$(CMD_MV) -f $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(CSRCS)))) $(OBJS_DIR)


# %jp{祢֥}%en{batch cmpile}
batch_asm:
#	$(CMD_CC) $(CFLAGS) -c $(ASRCS)
#	$(CMD_MV) -f $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(ASRCS)))) $(OBJS_DIR)



# end of file
