# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#    common file for GNU make
#
#  Copyright (C) 1998-2006 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{ץ}
# --------------------------------------

ifeq ($(DEBUG),Yes)
# %jp{ǥХå꤬ХǥХåǺ}
AFLAGS += $(AFLAGS_DBG) $(AFLAGS_OPT_NONE)
CFLAGS += $(CFLAGS_DBG) $(CFLAGS_OPT_NONE)
else
ifeq ($(OPT_SPEED),Yes)
# %jp{®ٺŬ꤬®ͥ}
AFLAGS += $(AFLAGS_OPT_SPEED)
CFLAGS += $(CFLAGS_OPT_SPEED)
else
ifeq ($(OPT_SIZE),Yes)
# %jp{ͥŬ꤬Хͥ}
AFLAGS += $(AFLAGS_OPT_SIZE)
CFLAGS += $(CFLAGS_OPT_SIZE)
else
# %jp{ǥեȤ̾κŬ}
AFLAGS += $(AFLAGS_OPT_NORMAL)
CFLAGS += $(CFLAGS_OPT_NORMAL)
endif
endif
endif



# --------------------------------------
#  %jp{ͥ饤֥}
# --------------------------------------

KERNEL_LIB_NAME ?= libhosv4a
KERNEL_MAKOPT   ?=

# %jp{ǥХå}
KERNEL_MAKOPT += DEBUG=$(KERNEL_DEBUG)
ifeq ($(KERNEL_DEBUG),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)dbg
endif


# %jp{顼٥}
KERNEL_MAKOPT += ERRLEVEL=$(KERNEL_ERRLEVEL)
ifeq ($(KERNEL_ERRLEVEL),0)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er0
endif
ifeq ($(KERNEL_ERRLEVEL),1)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er1
endif
ifeq ($(KERNEL_ERRLEVEL),2)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er2
endif
ifeq ($(KERNEL_ERRLEVEL),3)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er3
endif
ifeq ($(KERNEL_ERRLEVEL),4)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er4
endif


# %jp{ͥեå}%en{kernel hook}
KERNEL_MAKOPT += HOK_TSK=$(KERNEL_HOK_TSK)
ifeq ($(KERNEL_HOK_TSK),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)tsk
endif
KERNEL_MAKOPT += HOK_INH=$(KERNEL_HOK_INH)
ifeq ($(KERNEL_HOK_INH),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)inh
endif
KERNEL_MAKOPT += HOK_ISR=$(KERNEL_HOK_ISR)
ifeq ($(KERNEL_HOK_ISR),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)isr
endif

# %jp{ͥ饤֥}%en{kernel library}
KERNEL_LIB = $(KERNEL_BUILD_DIR)/$(KERNEL_LIB_NAME).$(EXT_LIB)


# --------------------------------------
#  %jp{ͥѤ}
# --------------------------------------

INC_DIRS += $(KERNEL_DIR)/include
LIBS     += $(KERNEL_LIB)



# --------------------------------------
#  %jp{Ƽ}
# --------------------------------------

# %jp{ѥ}
VPATH = $(subst $(space),:,$(SRC_DIRS))


# %jp{֥ȥե}
OBJS = $(addprefix $(OBJS_DIR)/, $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(ASRCS)))))	\
       $(addprefix $(OBJS_DIR)/, $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(CSRCS)))))



# --------------------------------------
#  %jp{롼}
# --------------------------------------


# %jp{ͥ饤֥}
$(KERNEL_LIB): kernel_make


# %jp{¹ԥե}
.PHONY : makeexe_all
makeexe_all: $(KERNEL_LIB) makeexe_mkobjsdir $(CSRCS) $(ASRCS)


# %jp{꡼ʥå}
.PHONY : makeexe_clean
makeexe_clean:
	$(CMD_RM) -f $(TARGET_LIB) $(OBJS)


# %jp{֥Ƚϥǥ쥯ȥ}
.PHONY : makeexe_mkobjsdir
makeexe_mkobjsdir:
	$(CMD_MKDIR) -p $(OBJS_DIR)


# %jp{¸ط}
DEPFLAGS += -MM $(patsubst %,-I%,$(INC_DIRS))
.PHONY : makeexe_depend
makeexe_depend: makeexe_mkobjsdir
	$(CMD_DEPEND) $(DEPFLAGS) $(CSRCS) | sed -e 's?\.o?\.$(EXT_OBJ)?g' | sed -e 's?^\(.*\):?$(OBJS_DIR)/\1:?g' > $(OBJS_DIR)/depend.inc

-include $(OBJS_DIR)/depend.inc


# %jp{Υԡ}
ifneq ($(SRCCPYDIR),)
.PHONY : makeexe_srccpy
makeexe_srccpy:
	$(CMD_CP) -t $(SRCCPYDIR) $(ASRCS) $(CSRCS)
endif


# %jp{ͥ}
.PHONY : kernel_make
kernel_make:
	$(MAKE) -C $(KERNEL_BUILD_DIR) -f gmake.mak $(KERNEL_MAKOPT)


# %jp{ͥ륯꡼}
.PHONY : kernel_clean
kernel_clean:
	$(MAKE) -C $(KERNEL_BUILD_DIR) -f gmake.mak $(KERNEL_MAKOPT) clean


# %jp{ͥdepend}
.PHONY : kernel_depend
kernel_depend:
	$(MAKE) -C $(KERNEL_BUILD_DIR) -f gmake.mak $(KERNEL_MAKOPT) depend



# end of file
