# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#    common file for GNU make
#
#  Copyright (C) 1998-2008 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{ץ}%en{analyze option}
# --------------------------------------

ifeq ($(DEBUG),Yes)
# %jp{ǥХå꤬ХǥХåǺ}%en{debug mode}
TARGET := $(TARGET)dbg
C_DEFS += _DEBUG
A_DEFS += _DEBUG
AFLAGS += $(AFLAGS_DBG) $(AFLAGS_OPT_NONE)
CFLAGS += $(CFLAGS_DBG) $(CFLAGS_OPT_NONE)
else
ifeq ($(OPT_SPEED),Yes)
# %jp{®ٺŬ꤬®ͥ}%en{speed optimize}
AFLAGS += $(AFLAGS_OPT_SPEED)
CFLAGS += $(CFLAGS_OPT_SPEED)
else
ifeq ($(OPT_SIZE),Yes)
# %jp{ͥŬ꤬Хͥ}%en{size optimize}
AFLAGS += $(AFLAGS_OPT_SIZE)
CFLAGS += $(CFLAGS_OPT_SIZE)
else
# %jp{ǥեȤ̾κŬ}%en{default}
AFLAGS += $(AFLAGS_OPT_NORMAL)
CFLAGS += $(CFLAGS_OPT_NORMAL)
endif
endif
endif



# --------------------------------------
#  %jp{ͥ饤֥}%en{select kernel library}
# --------------------------------------

KERNEL_LIB_NAME ?= libhosv4a
KERNEL_MAKOPT   ?=

# %jp{ǥХå}%en{debug mode}
KERNEL_MAKOPT += DEBUG=$(KERNEL_DEBUG)
ifeq ($(KERNEL_DEBUG),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)dbg
endif


# %jp{顼٥}%en{error check level}
KERNEL_MAKOPT += ERRLEVEL=$(KERNEL_ERRLEVEL)
ifeq ($(KERNEL_ERRLEVEL),0)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er0
endif
ifeq ($(KERNEL_ERRLEVEL),1)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er1
endif
ifeq ($(KERNEL_ERRLEVEL),2)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er2
endif
ifeq ($(KERNEL_ERRLEVEL),3)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er3
endif
ifeq ($(KERNEL_ERRLEVEL),4)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er4
endif


# %jp{ͥեå}%en{kernel hook}
KERNEL_MAKOPT += HOK_TSK=$(KERNEL_HOK_TSK)
ifeq ($(KERNEL_HOK_TSK),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)tsk
endif
KERNEL_MAKOPT += HOK_INH=$(KERNEL_HOK_INH)
ifeq ($(KERNEL_HOK_INH),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)inh
endif
KERNEL_MAKOPT += HOK_ISR=$(KERNEL_HOK_ISR)
ifeq ($(KERNEL_HOK_ISR),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)isr
endif

# %jp{ͥ饤֥}%en{kernel library}
KERNEL_LIB = $(KERNEL_BUILD_DIR)/$(KERNEL_LIB_NAME).$(EXT_LIB)



# --------------------------------------
#  %jp{ͥѤ}%en{add kernel setting}
# --------------------------------------

INC_DIRS += $(KERNEL_DIR)/include
LIBS     += $(KERNEL_LIB)



# --------------------------------------
#  %jp{Ƽ}%en{other setting}
# --------------------------------------

# %jp{ѥ}
VPATH = $(subst $(space),:,$(SRC_DIRS))


# %jp{֥ȥեϥǥ쥯ȥ}
OBJS_DIR = objs_$(TARGET)


# %jp{֥ȥե}
OBJS = $(addprefix $(OBJS_DIR)/, $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(ASRCS)))))	\
       $(addprefix $(OBJS_DIR)/, $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(CSRCS)))))



# end of file
