# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#    common include file for execution file
#
#  Copyright (C) 1998-2007 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------




# --------------------------------------
#  %jp{ץ}
# --------------------------------------

!ifndef DEBUG
DEBUG = No
!endif

!ifndef OPT_SPEED
OPT_SPEED = No
!endif

!ifndef OPT_SIZE
OPT_SIZE = No
!endif

!ifndef KERNEL_DEBUG
KERNEL_DEBUG = No
!endif


!if "$(DEBUG)" == "Yes"
# %jp{ǥХå꤬ХǥХåǺ}
TARGET = $(TARGET)dbg
AFLAGS = $(AFLAGS) $(AFLAGS_DBG) $(AFLAGS_OPT_NONE)
CFLAGS = $(CFLAGS) $(CFLAGS_DBG) $(CFLAGS_OPT_NONE)
!else
!if "$(OPT_SPEED)" == "Yes"
# %jp{®ٺŬ꤬®ͥ}
AFLAGS = $(AFLAGS) $(AFLAGS_OPT_SPEED)
CFLAGS = $(CFLAGS) $(AFLAGS_OPT_SPEED)
!else
!if "$(OPT_SIZE)" == "Yes"
# %jp{ͥŬ꤬Хͥ}
AFLAGS = $(AFLAGS) $(AFLAGS_OPT_SIZE)
CFLAGS = $(CFLAGS) $(AFLAGS_OPT_SIZE)
!else
# %jp{ǥեȤ̾κŬ}
AFLAGS = $(AFLAGS) $(AFLAGS_OPT_NORMAL)
CFLAGS = $(CFLAGS) $(AFLAGS_OPT_NORMAL)
!endif
!endif
!endif



# --------------------------------------
#  %jp{å}
# --------------------------------------

# %jp{åȼ¹ԥե̾}
TARGET_EXE = $(TARGET).$(EXT_EXE)



# --------------------------------------
#  %jp{Ƽޥʸ}
# --------------------------------------

!ifdef OBJS
OBJS = $(OBJS:	= )
OBJS = $(OBJS:  = )
OBJS = $(OBJS:  = )
OBJS = $(OBJS:  = )
OBJS = $(OBJS:  = )
OBJS = @$(OBJS)@
OBJS = $(OBJS:@ =)
OBJS = $(OBJS: @=)
OBJS = $(OBJS:@=)
!endif

!ifdef LIBS
LIBS = $(LIBS:	= )
LIBS = $(LIBS:  = )
LIBS = $(LIBS:  = )
LIBS = $(LIBS:  = )
LIBS = $(LIBS:  = )
LIBS = @$(LIBS)@
LIBS = $(LIBS:@ =)
LIBS = $(LIBS: @=)
LIBS = $(LIBS:@=)
!endif



# --------------------------------------
#  %jp{ͥ饤֥}
# --------------------------------------

!ifndef KERNEL_LIB_NAME
KERNEL_LIB_NAME = libhosv4a
!endif


# %jp{ǥХå}
!if "$(KERNEL_DEBUG)" == "Yes"
KERNEL_LIB_NAME = $(KERNEL_LIB_NAME)dbg
!endif


# %jp{顼٥}
!ifdef KERNEL_ERRLEVEL
!if $(KERNEL_ERRLEVEL) == 0
KERNEL_LIB_NAME = $(KERNEL_LIB_NAME)er0
!elseif $(KERNEL_ERRLEVEL) == 1
KERNEL_LIB_NAME = $(KERNEL_LIB_NAME)er1
!elseif $(KERNEL_ERRLEVEL) == 2
KERNEL_LIB_NAME = $(KERNEL_LIB_NAME)er2
!elseif $(KERNEL_ERRLEVEL) == 3
KERNEL_LIB_NAME = $(KERNEL_LIB_NAME)er3
!elseif $(KERNEL_ERRLEVEL) == 4
KERNEL_LIB_NAME = $(KERNEL_LIB_NAME)er4
!endif
!endif

# kernel library
KERNEL_LIB = $(KERNEL_BUILD_DIR)\$(KERNEL_LIB_NAME).$(EXT_LIB)


# --------------------------------------
#  %jp{ͥѤ}
# --------------------------------------

INC_DIRS = $(INC_DIRS) $(KERNEL_DIR)\include
LIBS     = $(LIBS) $(KERNEL_LIB)



# --------------------------------------
#  %jp{롼}
# --------------------------------------


# %jp{ͥ饤֥}
$(KERNEL_LIB): kernel_make


# %jp{all}
makeexe_all: $(KERNEL_LIB) mkdir_objs $(CSRCS) $(ASRCS)


# %jp{֥Ƚϥǥ쥯ȥ}
mkdir_objs:
	-$(CMD_MKDIR) $(OBJS_DIR)


# %jp{꡼ʥå}
makeexe_clean:
	-$(CMD_RM) $(TARGET_LIB) $(OBJS)


# %jp{ͥ}
kernel_make:
	$(CMD_CD) $(KERNEL_BUILD_DIR)
	$(MAKE) -f nmake.mak DEBUG=$(KERNEL_DEBUG) ERRLEVEL=$(KERNEL_ERRLEVEL)
	$(CMD_CD) $(MAKEDIR)


# %jp{ͥ}
kernel_clean:
	$(CMD_CD) $(KERNEL_BUILD_DIR)
	$(MAKE) -f nmake.mak DEBUG=$(KERNEL_DEBUG) ERRLEVEL=$(KERNEL_ERRLEVEL) clean
	$(CMD_CD) $(MAKEDIR)



# end of file
