# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for H8/300H advanced mode
#
# Copyright (C) 1998-2006 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET ?= libhosv4a

# %jp{ƥѥ}
ARCH_PROC ?= h8/h8300ha
ARCH_IRC  ?= simple
ARCH_CC   ?= gcc

# %jp{ġ}
GCC_ARCH ?= h8300-elf-
CMD_CC   ?= $(GCC_ARCH)gcc
CMD_ASM  ?= $(GCC_ARCH)gcc
CMD_LIBR ?= $(GCC_ARCH)ar

# %jp{ǥ쥯ȥ}
TOP_DIR           = ../../../../..
KERNEL_DIR        = $(TOP_DIR)/kernel
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
OBJS_DIR          = objs_$(TARGET)


# %jp{ͥ}
KERNEL = Yes


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ƥѥ}
INC_PROC_DIR     = $(KERNEL_DIR)/include/arch/proc/$(ARCH_PROC)
INC_IRC_DIR      = $(KERNEL_DIR)/include/arch/irc/$(ARCH_IRC)
SRC_PROC_DIR     = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)
SRC_PROC_ASM_DIR = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)/$(ARCH_CC)
SRC_IRC_DIR      = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)
SRC_IRC_ASM_DIR  = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)/$(ARCH_CC)

# %jp{ѥ}
INC_DIRS += $(INC_PROC_DIR) $(INC_IRC_DIR)
SRC_DIRS += $(SRC_PROC_DIR) $(SRC_PROC_DIR) $(SRC_PROC_ASM_DIR) $(SRC_IRC_DIR) $(SRC_IRC_ASM_DIR)

# %jp{ץե饰}
AFLAGS += -mh
CFLAGS += -mh
LFLAGS += 

# %jp{ե졼}
CFGRTR_DIR = $(TOP_DIR)/cfgrtr/build/gcc
CFGRTR     = h4acfg-h8300ha


# Cեɲ
CSRCS += $(SRC_PROC_DIR)/val_int.c				\
         $(SRC_PROC_DIR)/chg_imsk.c				\
         $(SRC_PROC_DIR)/get_imsk.c				\
         $(SRC_IRC_DIR)/ena_int.c				\
         $(SRC_IRC_DIR)/dis_int.c				\
         $(SRC_IRC_DIR)/clr_int.c				\
         $(SRC_IRC_DIR)/chg_ilv.c				\
         $(SRC_IRC_DIR)/get_ilv.c


# ֥եɲ
ASRCS += $(SRC_PROC_ASM_DIR)/kini_prc.S			\
         $(SRC_PROC_ASM_DIR)/kena_int.S			\
         $(SRC_PROC_ASM_DIR)/kdis_int.S			\
         $(SRC_PROC_ASM_DIR)/kwai_int.S			\
         $(SRC_PROC_ASM_DIR)/kcre_ctx.S			\
         $(SRC_PROC_ASM_DIR)/krst_ctx.S			\
         $(SRC_PROC_ASM_DIR)/kswi_ctx.S			\
         $(SRC_PROC_ASM_DIR)/kint_hdr.S			\
         $(SRC_PROC_ASM_DIR)/vect_dmy.S			\
         $(SRC_PROC_ASM_DIR)/vect_001.S			\
         $(SRC_PROC_ASM_DIR)/vect_002.S			\
         $(SRC_PROC_ASM_DIR)/vect_003.S			\
         $(SRC_PROC_ASM_DIR)/vect_004.S			\
         $(SRC_PROC_ASM_DIR)/vect_005.S			\
         $(SRC_PROC_ASM_DIR)/vect_006.S			\
         $(SRC_PROC_ASM_DIR)/vect_007.S			\
         $(SRC_PROC_ASM_DIR)/vect_008.S			\
         $(SRC_PROC_ASM_DIR)/vect_009.S			\
         $(SRC_PROC_ASM_DIR)/vect_010.S			\
         $(SRC_PROC_ASM_DIR)/vect_011.S			\
         $(SRC_PROC_ASM_DIR)/vect_012.S			\
         $(SRC_PROC_ASM_DIR)/vect_013.S			\
         $(SRC_PROC_ASM_DIR)/vect_014.S			\
         $(SRC_PROC_ASM_DIR)/vect_015.S			\
         $(SRC_PROC_ASM_DIR)/vect_016.S			\
         $(SRC_PROC_ASM_DIR)/vect_017.S			\
         $(SRC_PROC_ASM_DIR)/vect_018.S			\
         $(SRC_PROC_ASM_DIR)/vect_019.S			\
         $(SRC_PROC_ASM_DIR)/vect_020.S			\
         $(SRC_PROC_ASM_DIR)/vect_021.S			\
         $(SRC_PROC_ASM_DIR)/vect_022.S			\
         $(SRC_PROC_ASM_DIR)/vect_023.S			\
         $(SRC_PROC_ASM_DIR)/vect_024.S			\
         $(SRC_PROC_ASM_DIR)/vect_025.S			\
         $(SRC_PROC_ASM_DIR)/vect_026.S			\
         $(SRC_PROC_ASM_DIR)/vect_027.S			\
         $(SRC_PROC_ASM_DIR)/vect_028.S			\
         $(SRC_PROC_ASM_DIR)/vect_029.S			\
         $(SRC_PROC_ASM_DIR)/vect_030.S			\
         $(SRC_PROC_ASM_DIR)/vect_031.S			\
         $(SRC_PROC_ASM_DIR)/vect_032.S			\
         $(SRC_PROC_ASM_DIR)/vect_033.S			\
         $(SRC_PROC_ASM_DIR)/vect_034.S			\
         $(SRC_PROC_ASM_DIR)/vect_035.S			\
         $(SRC_PROC_ASM_DIR)/vect_036.S			\
         $(SRC_PROC_ASM_DIR)/vect_037.S			\
         $(SRC_PROC_ASM_DIR)/vect_038.S			\
         $(SRC_PROC_ASM_DIR)/vect_039.S			\
         $(SRC_PROC_ASM_DIR)/vect_040.S			\
         $(SRC_PROC_ASM_DIR)/vect_041.S			\
         $(SRC_PROC_ASM_DIR)/vect_042.S			\
         $(SRC_PROC_ASM_DIR)/vect_043.S			\
         $(SRC_PROC_ASM_DIR)/vect_044.S			\
         $(SRC_PROC_ASM_DIR)/vect_045.S			\
         $(SRC_PROC_ASM_DIR)/vect_046.S			\
         $(SRC_PROC_ASM_DIR)/vect_047.S			\
         $(SRC_PROC_ASM_DIR)/vect_048.S			\
         $(SRC_PROC_ASM_DIR)/vect_049.S			\
         $(SRC_PROC_ASM_DIR)/vect_050.S			\
         $(SRC_PROC_ASM_DIR)/vect_051.S			\
         $(SRC_PROC_ASM_DIR)/vect_052.S			\
         $(SRC_PROC_ASM_DIR)/vect_053.S			\
         $(SRC_PROC_ASM_DIR)/vect_054.S			\
         $(SRC_PROC_ASM_DIR)/vect_055.S			\
         $(SRC_PROC_ASM_DIR)/vect_056.S			\
         $(SRC_PROC_ASM_DIR)/vect_057.S			\
         $(SRC_PROC_ASM_DIR)/vect_058.S			\
         $(SRC_PROC_ASM_DIR)/vect_059.S			\
         $(SRC_PROC_ASM_DIR)/vect_060.S			\
         $(SRC_PROC_ASM_DIR)/vect_061.S			\
         $(SRC_PROC_ASM_DIR)/vect_062.S			\
         $(SRC_PROC_ASM_DIR)/vect_063.S


# ͥ붦̥ɲ
include $(KERNEL_MAKINC_DIR)/knlsrc.inc


# %jp{ALL}
.PHONY : all
all: makelib_all
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC)

# %jp{꡼}
.PHONY : clean
clean: makelib_clean
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC) clean
	$(RM) -f *.lst



# %jp{gccѤɹ}
include $(KERNEL_MAKINC_DIR)/gcc_d.inc

# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makelib.inc


# %jp{ch38ѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/gcc_r.inc

# %jp{ͥ¸طɹ}
include $(KERNEL_MAKINC_DIR)/knldep.inc


# end of file
