/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ctxctl.h
 * @brief %jp{ƥ}%en{context control}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__arch__proc__mn1030__proc_h__
#define _KERNEL__arch__proc__mn1030__proc_h__



/** %jp{ƥȾ¸֥å} */
typedef struct _kernel_t_ctxcb
{
	VP_INT  sp;
} _KERNEL_T_CTXCB;


/** %jp{ߥƥ֥å} */
typedef struct _kernel_t_ictxcb
{
	VP	isp;
	UB	intcnt;
} _KERNEL_T_ICTXCB;


extern _KERNEL_T_ICTXCB _kernel_ictxcb;		/**< %jp{ߥƥ֥å} */



#ifdef __cplusplus
extern "C" {
#endif

void    _kernel_ini_prc(void);																		/**< %jp{ץåͭν} */

void    _kernel_ena_int(void);																		/**< %jp{ߵ} */
void    _kernel_dis_int(void);																		/**< %jp{߶ػ} */
void    _kernel_wai_int(void);																		/**< %jp{Ԥ(ɥν)} */

void    _kernel_cre_ctx(UW par1, UW par2, _KERNEL_T_CTXCB *pk_ctxcb, VP isp, FP entry);				/**< %jp{¹ԥƥȤκ} */
void    _kernel_del_ctx(_KERNEL_T_CTXCB *pk_ctxcb);													/**< %jp{¹ԥƥȤκ} */
void    _kernel_rst_ctx(UW par1, UW par2, FP entry, VP isp);										/**< %jp{¹ԥƥȤΥꥹ} */
void    _kernel_sta_ctx(_KERNEL_T_CTXCB *pk_ctxcb);													/**< %jp{¹ԥƥȤγ} */
void    _kernel_swi_ctx(_KERNEL_T_CTXCB *pk_ctxinf_nxt, _KERNEL_T_CTXCB *pk_ctxcb_now);				/**< %jp{¹ԥƥȤ} */

#ifdef __cplusplus
}
#endif


#define _KERNEL_INI_PRC()			_kernel_ini_prc()												/**< %jp{ץåͭν} */

#define _KERNEL_INI_INT(stksz, stk)	do { _kernel_ictxcb.isp = (VB *)(stk) + (stksz); } while (0)	/**< %jp{߽} */
#define _KERNEL_ENA_INT()			_kernel_ena_int()												/**< %jp{ߵ} */
#define _KERNEL_DIS_INT()			_kernel_dis_int()												/**< %jp{߶ػ} */
#define _KERNEL_WAI_INT()			_kernel_wai_int()												/**< %jp{Ԥ(ɥν)} */

#define _KERNEL_CRE_CTX(pk_ctxcb, stksz, stk, isp, entry, par1, par2)			\
									_kernel_cre_ctx((UW)(par1), (UW)(par2), (pk_ctxcb), (isp), (entry))
#define _KERNEL_DEL_CTX(pk_ctxcb)	_kernel_del_ctx(pk_ctxcb)
#define _KERNEL_RST_CTX(pk_ctxcb, stksz, stk, isp, entry, exinf1, exinf2)		\
									_kernel_rst_ctx((exinf1), (exinf2), (entry), (isp))
#define _KERNEL_STA_CTX(pk_ctxcb)	_kernel_sta_ctx(pk_ctxcb)
#define _KERNEL_SWI_CTX(pk_ctxcb_now, pk_ctxinf_nxt)							\
									_kernel_swi_ctx((pk_ctxinf_nxt), (pk_ctxcb_now))


#endif	/* _KERNEL__arch__proc__arm__arm_v4__proc_h__ */


/* end of file */
