/**
 *  Hyper Operating System V4 Advance
 *
 * @file  proc.h
 * @brief %jp{ץåƥͭǽ}%en{Processor archtecture}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__win32__proc_h__
#define _KERNEL__win32__proc_h__


/** %jp{Windows إåեɤߤ} */
#define SIZE	WIN_SIZE
#define BOOL	WIN_BOOL
#include <windows.h>
#undef	SIZE
#undef	BOOL

#include <setjmp.h>



/** %jp{ƥȾ¸֥å} */
typedef struct _kernel_t_ctxcb
{
	FP					entry;				/**< %jp{ȥ꡼ɥ쥹} */
	VP_INT				exinf1;				/**< %jp{ѥ᡼} */
	VP_INT				exinf2;				/**< %jp{ѥ᡼} */
	jmp_buf				jmpenv;				/**< %jp{ƥȥꥻåѤlongjmpǡ} */

	BOOL				blInterrupt;		/**< %jp{߽ե饰} */
	HANDLE				hEvent;				/**< %jp{٥ȥϥɥ} */
	HANDLE				hThread;			/**< %jp{åɥϥɥ} */
	DWORD				dwThreadId;			/**< %jp{åID} */
	HANDLE				hIntEvent;			/**< %jp{٥ȥϥɥ} */
	HANDLE				hIntThread;			/**< %jp{åɥϥɥ} */
	DWORD				dwIntThreadId;		/**< %jp{åID} */
} _KERNEL_T_CTXCB;


/** %jp{ߥƥ֥å} */
typedef struct _kernel_t_ictxcb
{
	_KERNEL_T_CTXCB		*runctxcb;			/**< %jp{¹Υƥ} */
	INHNO				inhno;

	CRITICAL_SECTION	CriticalSection;	/**< %jp{ƥ륻} */
	HANDLE				hSemIntLock;		/**< %jp{ƥ¾ѥޥե} */
	volatile BOOL		blIntCtx;			/**< %jp{߽ե饰} */
	volatile BOOL		blDisInt;			/**< %jp{߶ػߥե饰} */
	DWORD				dwPrimaryThreadId;	/**< %jp{ץ饤ޥꥹåID} */
} _KERNEL_T_ICTXCB;


extern _KERNEL_T_ICTXCB _kernel_ictxcb;		/**< %jp{ߥƥ֥å} */



#ifdef __cplusplus
extern "C" {
#endif

void    _kernel_ini_prc(void);																/**< %jp{ƥͭν} */

void    _kernel_ena_int(void);																/**< %jp{ߵ} */
void    _kernel_dis_int(void);																/**< %jp{߶ػ} */
void    _kernel_wai_int(void);																/**< %jp{Ԥ(ɥν)} */

void    _kernel_cre_ctx(_KERNEL_T_CTXCB *ctxcb, FP entry, VP_INT exinf1, VP_INT exinf2);	/**< %jp{¹ԥƥȤκ} */
void    _kernel_del_ctx(_KERNEL_T_CTXCB *ctxcb);											/**< %jp{¹ԥƥȤκ} */
void    _kernel_rst_ctx(_KERNEL_T_CTXCB *ctxcb);											/**< %jp{¹ԥƥȤΥꥹ} */
void    _kernel_sta_ctx(_KERNEL_T_CTXCB *ctxcb);											/**< %jp{¹ԥƥȤγ} */
void    _kernel_swi_ctx(_KERNEL_T_CTXCB *ctxcb_now, _KERNEL_T_CTXCB *ctxinf_nxt);			/**< %jp{¹ԥƥȤ} */

void     vsig_int(int inhno);																/**< %jp{ߥݡAPI} */

#ifdef __cplusplus
}
#endif


#define _KERNEL_INI_PRC()				_kernel_ini_prc()

#define _KERNEL_INI_INT(stksz, stk)		do {} while(0)
#define _KERNEL_ENA_INT()				_kernel_ena_int()									/**< %jp{ߵ} */
#define _KERNEL_DIS_INT()				_kernel_dis_int()									/**< %jp{߶ػ} */
#define _KERNEL_WAI_INT()				_kernel_wai_int()									/**< %jp{Ԥ(ɥν)} */


#define _KERNEL_CRE_CTX(ctxcb, stksz, stk, isp, entry, par1, par2)		\
							_kernel_cre_ctx(ctxcb, entry, par1, par2)
#define _KERNEL_DEL_CTX(ctxcb)	_kernel_del_ctx(ctxcb)
#define _KERNEL_RST_CTX(ctxcb, stksz, stk, isp, entry, par1, par2)		\
							_kernel_rst_ctx(ctxcb)
#define _KERNEL_STA_CTX(ctxcb)	_kernel_sta_ctx(ctxcb)
#define _KERNEL_SWI_CTX(ctxcb_now, ctxcb_nxt)							\
							_kernel_swi_ctx(ctxcb_now, ctxcb_nxt)



#endif	/* _KERNEL__win32__proc_h__ */


/* end of file */
