/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cfgsys.h
 * @brief %jp{ITRONƥΥե졼ѥإåե}%en{ITRON system configuration heder file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


/*
%jp{
  ܥեˤơITRONƥΥե졼Ԥ
  ե졼η̤ˤꡢܷʤɥץꥱ
ѤѲ١ܥեѹϥͥΤߤʤ餺
itron.h  kernel.h ѤƤ롢ץꥱ¦ޤ
ƥΤӥɤɬפ롣
  ޤܥեϥ֥ˤȤꤷƤΤǡ
C칽ʸ(㤨typedefʤ)Ϥˤϵܤޥʤɤ
ץץåǥ쥯ƥ֤Τߤ򵭺ܤȤ롣
}
*/



#ifndef _KERNEL__config__cfgsys_h__
#define _KERNEL__config__cfgsys_h__


/* %jp{Υ饤󥵥}%jp{Memory alignment size} */
#define _KERNEL_CFG_MEM_ALIGN			(-1)				/**< Υ饤󥵥(-1λǥե)}%en{Memory alignment size (-1:default)} */


/* %jp{ITRONͶ̥ǡ}%en{ITRON General Data Type} */
#define _KERNEL_CFG_TBIT_INT			(-1)				/**< %jp{INT     Υӥåȿ (-1λǥե)}%en{Number of bits in INT     (-1:default)} */
#define _KERNEL_CFG_TBIT_UINT			(-1)				/**< %jp{UINT    Υӥåȿ (-1λǥե)}%en{Number of bits in UINT    (-1:default)} */
#define _KERNEL_CFG_TBIT_BOOL			(-1)				/**< %jp{BOOL    Υӥåȿ (-1λǥե)}%en{Number of bits in BOOL    (-1:default)} */
#define _KERNEL_CFG_TBIT_FN				(-1)				/**< %jp{FN      Υӥåȿ (-1λǥե)}%en{Number of bits in FN      (-1:default)} */
#define _KERNEL_CFG_TBIT_ER				(-1)				/**< %jp{ER      Υӥåȿ (-1λǥե)}%en{Number of bits in ER      (-1:default)} */
#define _KERNEL_CFG_TBIT_ID				(-1)				/**< %jp{ID      Υӥåȿ (-1λǥե)}%en{Number of bits in ID      (-1:default)} */
#define _KERNEL_CFG_TBIT_ATR			(-1)				/**< %jp{ATR     Υӥåȿ (-1λǥե)}%en{Number of bits in ATR     (-1:default)} */
#define _KERNEL_CFG_TBIT_STAT			(-1)				/**< %jp{STAT    Υӥåȿ (-1λǥե)}%en{Number of bits in STAT    (-1:default)} */
#define _KERNEL_CFG_TBIT_MODE			(-1)				/**< %jp{MODE    Υӥåȿ (-1λǥե)}%en{Number of bits in MODE    (-1:default)} */
#define _KERNEL_CFG_TBIT_PRI			(-1)				/**< %jp{PRI     Υӥåȿ (-1λǥե)}%en{Number of bits in PRI     (-1:default)} */
#define _KERNEL_CFG_TBIT_SIZE			(-1)				/**< %jp{SIZE    Υӥåȿ (-1λǥե)}%en{Number of bits in SIZE    (-1:default)} */
#define _KERNEL_CFG_TBIT_TMO			(-1)				/**< %jp{TMO     Υӥåȿ (-1λǥե)}%en{Number of bits in TMO     (-1:default)} */
#define _KERNEL_CFG_TBIT_RELTIM			(-1)				/**< %jp{RELTIM  Υӥåȿ (-1λǥե)}%en{Number of bits in RELTIM  (-1:default)} */
#define _KERNEL_CFG_SYSTIM_STRUCT		FALSE				/**< %jp{SYSTIM¤Τˤ뤫ɤ} */
#define _KERNEL_CFG_TBIT_SYSTIM			32					/**< %jp{SYSTIMΥӥåȿ} */
#define _KERNEL_CFG_VP_INT_PTR			FALSE				/**< %jp{VP_INTݥ󥿷ˤ뤫ɤ} */
#define _KERNEL_CFG_TBIT_VP_INT			(-1)				/**< %jp{VP_INT  Υӥåȿ (-1λǥե)}%en{Number of bits in VP_INT  (-1:default)} */
#define _KERNEL_CFG_TBIT_ER_BOOL		(-1)				/**< %jp{ER_BOOL Υӥåȿ (-1λǥե)}%en{Number of bits in ER_BOOL (-1:default)} */
#define _KERNEL_CFG_TBIT_ER_ID			(-1)				/**< %jp{ER_ID   Υӥåȿ (-1λǥե)}%en{Number of bits in ER_ID   (-1:default)} */
#define _KERNEL_CFG_TBIT_ER_UINT		(-1)				/**< %jp{ER_UINT Υӥåȿ (-1λǥե)}%en{Number of bits in ER_UINT (-1:default)} */

/* %jp{ͥΥǡ}%en{Kernel Data Type} */
#define _KERNEL_CFG_TBIT_TEXPTN			(-1)				/**< %jp{㳰װΥӥåȿ(-1λǥե)} */
#define _KERNEL_CFG_TBIT_FLGPTN			(-1)				/**< %jp{٥ȥե饰Υӥåȿ(-1λǥե)} */
#define _KERNEL_CFG_TBIT_RDVPTN			(-1)				/**< %jp{ǥ־Υӥåȿ(-1λǥե)} */
#define _KERNEL_CFG_TBIT_RDVNO			(-1)
#define _KERNEL_CFG_TBIT_OVRTIM			(-1)
#define _KERNEL_CFG_TBIT_INHNO			(-1)
#define _KERNEL_CFG_TBIT_INTNO			(-1)
#define _KERNEL_CFG_TBIT_EXCNO			(-1)


/* %jp{ͥ٤ϰ}%en{Priority Range} */
#define _KERNEL_CFG_TMAX_TPRI			127					/**< %jp{ͥ٤κ(-1λǥե)}%en{Maximum task priority} */
#define _KERNEL_CFG_TMAX_MPRI			127					/**< %jp{åͥ٤κ(-1λǥե)}%en{Maximum message priority} */

/* %jp{塼󥰡ͥȲκ}%en{Maximum Nesting/Queueing Count} */
#define _KERNEL_CFG_TMAX_ACTCNT			127					/**< %jp{ư׵ᥭ塼󥰿κ(-1λǥե)} */
#define _KERNEL_CFG_TMAX_WUPCNT			127					/**< %jp{׵ᥭ塼󥰿κ(-1λǥե)} */
#define _KERNEL_CFG_TMAX_SUSCNT			127					/**< %jp{Ԥ׵ͥȿκ(-1λǥե)} */

/* %jp{ӥåȥѥΥӥåȿ} %en{Number of Bits in Bitpatterns}*/
#define _KERNEL_CFG_TEX_TBIT_TEXPTN		(-1)				/**< %jp{㳰װΥӥåȿ(-1λǥե)} */
#define _KERNEL_CFG_FLG_TBIT_FLGPTN		(-1)				/**< %jp{٥ȥե饰Υӥåȿ(-1λǥե)} */
#define _KERNEL_CFG_RDV_TBIT_RDVPTN		(-1)				/**< %jp{ǥ־Υӥåȿ(-1λǥե)} */

/* %jp{ޥեκ}%en{Maximum value of the maximum definable semaphore resource count} */
#define _KERNEL_CFG_TMAX_MAXSEM			(-1)				/**< %jp{ޥեκ}%en{Maximum value of the maximum definable semaphore resource count} */


/* %jp{T_RTSKѹ}%en{T_RTSKѹ} */
#define _KERNEL_CFG_RTSK_TSKATR			TRUE				/**< %jp{T_RTSK tskatr ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTSK_EXINF			TRUE				/**< %jp{T_RTSK exinf ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTSK_TASK			TRUE				/**< %jp{T_RTSK task ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTSK_ITSKPRI		TRUE				/**< %jp{T_RTSK itskpri ޤ뤫(HOSȼĥǽ)} */	
#define _KERNEL_CFG_RTSK_STKSZ			TRUE				/**< %jp{T_RTSK stksz ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTSK_STK			TRUE				/**< %jp{T_RTSK stk ޤ뤫(HOSȼĥǽ)} */


/* %jp{T_RTSTι}%en{T_RTST} */
#define _KERNEL_CFG_RTST_TSKATR			FALSE				/**< %jp{T_RTST tskatr ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTST_EXINF			TRUE				/**< %jp{T_RTST exinf ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTST_TASK			FALSE				/**< %jp{T_RTST task ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTST_ITSKPRI		FALSE				/**< %jp{T_RTST itskpri ޤ뤫(HOSȼĥǽ)} */	
#define _KERNEL_CFG_RTST_STKSZ			FALSE				/**< %jp{T_RTST stksz ޤ뤫(HOSȼĥǽ)} */
#define _KERNEL_CFG_RTST_STK			FALSE				/**< %jp{T_RTST stk ޤ뤫(HOSȼĥǽ)} */



#endif	/* _KERNEL__config__cfgsys_h__ */



/* end of file */
