/**
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp.h
 * @brief %jp{ǥѥåΥإåե}%en{task dispatcher heder file}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef _KERNEL_core__dsp_h__
#define _KERNEL_core__dsp_h__



#ifdef __cplusplus
extern "C" {
#endif

void _kernel_dsp_tsk(void);								/**< %jp{ǥѥå} */
void _kernel_ent_tsk(VP_INT exinf1, VP_INT exinf2);		/**< %jp{ȥ꡼ݥ} */

void _kernel_dsp_sta_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{¾򳫻Ϥ} */
void _kernel_dsp_ext_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{λ} */
void _kernel_dsp_ter_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{¾λ} */
void _kernel_dsp_wai_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{Ԥ֤ˤ} */
void _kernel_dsp_wup_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{¾Ԥ} */
void _kernel_dsp_sus_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{򥵥ڥɤ} */
void _kernel_dsp_rsm_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{򥵥ڥɲ} */

#ifdef __cplusplus
}
#endif


#define _KERNEL_DSP_TSK()				_kernel_dsp_tsk()				/**< %jp{塼¹} */


#if _KERNEL_SPT_SUS_TSK	/*  %jp{ڥɤΥǥξ} */

#define _KERNEL_DSP_STA_TSK(tskhdl)		_kernel_dsp_sta_tsk(tskhdl)		/**< %jp{¾򳫻Ϥ} */
#define _KERNEL_DSP_EXT_TSK(tskhdl)		_kernel_dsp_ext_tsk(tskhdl)		/**< %jp{λ} */
#define _KERNEL_DSP_TER_TSK(tskhdl)		_kernel_dsp_ter_tsk(tskhdl)		/**< %jp{¾λ} */
#define _KERNEL_DSP_WAI_TSK(tskhdl)		_kernel_dsp_wai_tsk(tskhdl)		/**< %jp{Ԥ֤ˤ} */
#define _KERNEL_DSP_WUP_TSK(tskhdl)		_kernel_dsp_wup_tsk(tskhdl)		/**< %jp{¾Ԥ} */
#define _KERNEL_DSP_SUS_TSK(tskhdl)		_kernel_dsp_sus_tsk(tskhdl)		/**< %jp{򥵥ڥɤ} */
#define _KERNEL_DSP_RSM_TSK(tskhdl)		_kernel_dsp_rsm_tsk(tskhdl)		/**< %jp{򥵥ڥɲ} */


#else /* %jp{ڥ̵Υǥξ} */

#if _KERNEL_RUNTSK_ON_RDQ	/* %jp{¹ǥ塼˷Ҥ} */

#define _KERNEL_DSP_STA_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< %jp{¾򳫻Ϥ} */
#define _KERNEL_DSP_EXT_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< %jp{λ} */
#define _KERNEL_DSP_TER_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< %jp{¾λ} */
#define _KERNEL_DSP_WAI_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_WAI); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< %jp{Ԥ֤ˤ} */
#define _KERNEL_DSP_WUP_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< %jp{¾Ԥ} */

#else /* %jp{¹ϥǥ塼鳰} */

#define _KERNEL_DSP_STA_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< ¾򳫻Ϥ */
#define _KERNEL_DSP_EXT_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT);                          } while (0)		/**< λ */
#define _KERNEL_DSP_TER_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< ¾λ */
#define _KERNEL_DSP_WAI_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_WAI);                          } while (0)		/**< Ԥ֤ˤ */
#define _KERNEL_DSP_WUP_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< ¾Ԥ */

#endif

#endif



#endif	/* _KERNEL_core__dsp_h__ */



/* end of file */
