/**
 *  Hyper Operating System V4 Advance
 *
 * @file  hep.h
 * @brief %jp{ҡפΥإåե}%en{memory heap heder file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__core__hep_h_
#define _KERNEL__core__hep_h_


#include "itron.h"


#define _KERNEL_HEP_MEMALIGN		32			/**< %jp{ꥢ饤} */
#define _KERNEL_HEP_USING			0x1234		/**< %jp{} */
#define _KERNEL_HEP_FREE			0xabcd		/**< %jp{̤} */



/** %jp{饤} */
#define _KERNEL_HEP_ALIGNED(size)	(((size) + _KERNEL_HEP_MEMALIGN - 1) & ~(_KERNEL_HEP_MEMALIGN - 1))


/** %jp{ҡץ֥å} */
typedef struct _kernel_t_hepblk
{
	struct _kernel_t_hepblk* prev;	/**< %jp{Υ֥å} */
	SIZE   size;					/**< %jp{֥åΥ} */
	INT    flag;					/**< %jp{ե饰} */
} _KERNEL_T_HEPBLK;


/** %jp{ҡ֥å} */
typedef struct _kernel_t_hepcb
{
	_KERNEL_T_HEPBLK *base;			/**< %jp{ͥѥƬ֥åΥɥ쥹} */
	SIZE            heapsz;			/**< %jp{ͥѥꥵ} */
} _KERNEL_T_HEPCB;


/** %jp{֥ͥå} */
#define _KERNEL_HEP_BLKSIZE			_KERNEL_HEP_ALIGNED(sizeof(_KERNEL_T_HEPBLK))


#ifdef __cplusplus
extern "C" {
#endif

void    _kernel_cre_hep(_KERNEL_T_HEPCB *hepcb, SIZE hepsz, VP hep);					/**< %jp{ҡפ} */
VP      _kernel_alc_hep(_KERNEL_T_HEPCB *hepcb, SIZE size);								/**< %jp{γ} */
void    _kernel_fre_hep(_KERNEL_T_HEPCB *hepcb, VP ptr);								/**< %jp{β} */

#ifdef __cplusplus
}
#endif


#define _KERNEL_CRE_HEP(hepcb, hepsz, hep)	_kernel_cre_hep((hepcb), (hepsz), (hep))	/**< %jp{ҡפ} */
#define _KERNEL_DEL_HEP(hepcb)				do {} while(0)								/**< %jp{ҡפ} */
#define _KERNEL_ALC_HEP(hepcb, size)		_kernel_alc_hep((hepcb), (size))			/**< %jp{γ} */
#define _KERNEL_FRE_HEP(hepcb, ptr)			_kernel_fre_hep((hepcb), (ptr))				/**< %jp{β} */
#define _KERNEL_ALG_HEP(hepcb, size)		_KERNEL_HEP_ALIGNED(size)					/**< %jp{ꥵΥ饤Ȥ碌} */



#endif	/* _KERNEL__core__hep_h_ */


/* end of file */
