/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kernel.h
 * @brief %jp{ͥإåե}%en{uITRON4.0 kernel header file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__kernel_h__
#define _KERNEL__kernel_h__


#include "itron.h"


/** %jp{С} */
#define TKERNEL_MAKER				0x0008					/**< %jp{᡼(Ŀ)} */
#define TKERNEL_PRID				0x0000					/**< %jp{ͥμֹ(̤)} */
#define TKERNEL_SPVER				0x5402					/**< %jp{ITRONͤΥС(ITRON Ver 4.02)} */
#define TKERNEL_PRVER				0x0000					/**< %jp{ͥΥСֹ(HOS-V4a Ver 0.00)} */


#define TMAX_ACTCNT					_KERNEL_TMAX_ACTCNT		/**< %jp{εư׵ᥭ塼󥰿κ} */
#define TMAX_WUPCNT					_KERNEL_TMAX_WUPCNT		/**< %jp{ε׵ᥭ塼󥰿κ} */
#define TMAX_SUSCNT					_KERNEL_TMAX_SUSCNT		/**< %jp{ζԤͥȿκ} */

#define TMAX_MAXSEM					_KERNEL_TMAX_MAXSEM		/**< %jp{ޥե񸻿κ} */


#define _KERNEL_TSZ_ALIGNED(size)	(((size) + _KERNEL_MEM_ALIGN - 1) & ~(_KERNEL_MEM_ALIGN - 1))

/** %jp{ǡ塼ΰΥ} */
#define TSZ_DTQ(dtqcnt)				((SIZE)(dtqcnt) * (SIZE)sizeof(VP_INT))

/** %jp{å塼إåΰΥ} */
#define TSZ_MPRIHD(maxmpri)			((SIZE)(maxmpri) * (SIZE)sizeof(T_MSG_PRI *))

/** %jp{סΰΥ} */
#define TSZ_MPF(blkcnt, blksz)		((SIZE)(blkcnt) * (SIZE)_KERNEL_TSZ_ALIGNED(blksz))

#define TSZ_MBF(msgcnt, msgsz)		((SIZE)(msgcnt) * (SIZE)((msgsz) + sizeof(UINT)))

#define TSZ_MPL(blkcnt, blksz)		((SIZE)(blkcnt) * ((SIZE)_KERNEL_TSZ_ALIGNED(blksz) + (SZIE)))



/** %jp{С} */
typedef struct t_rver
{
	UH      maker;			/**< %jp{ͥΥ᡼} */
	UH      prid;			/**< %jp{ͥμֹ} */
	UH      spver;			/**< %jp{ITRONͤΥС} */
	UH      prver;			/**< %jp{ͥΥСֹ} */
	UH      prno[4];		/**< %jp{ͥʤδ} */
} T_RVER;


/** %jp{} */
typedef struct t_ctsk
{
	ATR     tskatr;			/**< %jp{°} */
	VP_INT  exinf;			/**< %jp{γĥ} */
	FP      task;			/**< %jp{εư} */
	PRI     itskpri;		/**< %jp{εưͥ} */
	SIZE    stksz;			/**< %jp{åΰΥ(Хȿ)} */
	VP      stk;			/**< %jp{åΰƬ} */
} T_CTSK;

/** %jp{} */
typedef struct t_rtsk
{
	STAT    tskstat;		/**< %jp{} */
	PRI     tskpri;			/**< %jp{θͥ} */
	PRI	    tskbpri;		/**< %jp{Υ١ͥ} */
	STAT    tskwait;		/**< %jp{Ԥװ} */
	ID      wobjid;			/**< %jp{ԤоݤΥ֥ȤIDֹ} */
	TMO     lefttmo;		/**< %jp{ॢȤޤǤλ} */
	UINT    actcnt;			/**< %jp{ư׵ᥭ塼󥰲} */
	UINT    wupcnt;			/**< %jp{׵ᥭ塼󥰲} */
	UINT    suscnt;			/**< %jp{Ԥ׵ͥȲ} */
	
	/* %jp{ʲȼ}%en{HOS extention} */
#if _KERNEL_SPT_RTSK_TSKATR
	ATR     tskatr;			/**< %jp{°(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_EXINF
	VP_INT  exinf;			/**< %jp{γĥ(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_TASK
	FP      task;			/**< %jp{εư(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_ITSKPRI
	PRI     itskpri;		/**< %jp{εưͥ(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_STKSZ
	SIZE    stksz;			/**< %jp{åΰΥ(Хȿ)(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_STK
	VP      stk;			/**< %jp{åΰƬ(HOSȼĥ)} */
#endif
} T_RTSK;

/* (ʰ) */
typedef struct t_rtst
{
	STAT    tskstat;		/**< %jp{} */
	STAT    tskwait;		/**< %jp{Ԥװ} */
	
	/* %jp{ʲȼ}%en{HOS extention} */
#if _KERNEL_SPT_RTST_TSKATR
	ATR     tskatr;			/**< %jp{°(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_EXINF
	VP_INT  exinf;			/**< %jp{γĥ(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_TASK
	FP      task;			/**< %jp{εư(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_ITSKPRI
	PRI     itskpri;		/**< %jp{εưͥ(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_STKSZ
	SIZE    stksz;			/**< %jp{åΰΥ(Хȿ)(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_STK
	VP      stk;			/**< %jp{åΰƬ(HOSȼĥ)} */
#endif
} T_RTST;


/** %jp{㳰롼}%en{Task exception handling routine definition information} */
typedef struct t_dtex
{
	ATR		texatr;			/**< %jp{㳰롼°}%en{Task exception handling routine attribute} */
	FP		texrtn;			/**< %jp{㳰롼εư}%en{Task exception handling routine start address} */
} T_DTEX;


/** %jp{ޥե}%en{Semaphore creation information packet} */
typedef struct t_csem
{
	ATR		sematr;			/**< %jp{ޥե°}%en{Semaphoer attribute} */
	UINT	isemcnt;		/**< %jp{ޥե񸻿ν}%en{Initial semaphoer resource count} */
	UINT	maxsem;			/**< %jp{ޥեκ񸻿}%en{Maximum semaphoer resource count} */
} T_CSEM;

/** %jp{ޥե־}%en{Semaphore state packet} */
typedef struct t_rsem
{
	ID		wtskid;			/**< %jp{ޥեԤƬΥIDֹ}%en{ID number of the task at the head of the semaphore's wait queue} */
	UINT	semcnt;			/**< %jp{ޥեθߤλ񸻿}%en{Current semaphore resource count} */
} T_RSEM;


/** %jp{٥ȥե饰}%en{Eventflag creation information packet} */
typedef struct t_cflg
{
	ATR		flgatr;			/**< %jp{٥ȥե饰°}%en{Eventflag attribute} */
	FLGPTN	iflgptn;		/**< %jp{٥ȥե饰Υӥåȥѥν}%en{Initial value of eventflag bit pattern} */
} T_CFLG;

/** %jp{٥ȥե饰}%en{Eventflag state packet} */
typedef struct t_rflg
{
	ID		wtskid;			/**< %jp{٥ȥե饰ԤƬΥIDֹ}%en{ID number of the task at the head of the eventflag's wait queue} */
	FLGPTN	flgptn;			/**< %jp{٥ȥե饰θߤΥӥåȥѥ}%en{Eventflag's vurrent bit pattern} */
} T_RFLG;


/** %jp{ǡ塼}%en{Data queue creation information packet} */
typedef struct t_cdtq
{
	ATR  dtqatr;			/**< %jp{ǡ塼°}%en{Data queue attribute} */
	UINT dtqcnt;			/**< %jp{ǡ塼ΰ(ǡθĿ)}%en{Capacity of the data queue area(the number of data elements)} */
	VP   dtq;				/**< %jp{ǡ塼ΰƬ}%en{Start address of the data queue area} */
} T_CDTQ;

/** %jp{ǡ塼}%en{Data queue state packet} */
typedef struct t_rdtq
{
	ID		stskid;			/**< %jp{ǡ塼ԤƬΥIDֹ}%en{ID number of the task at the head of the send-wait queue} */
	ID		rtskid;			/**< %jp{ǡ塼μԤƬΥIDֹ}%en{ID number of the task at the head of the receive-wait queue} */
	UINT	sdtqcnt;		/**< %jp{ǡ塼äƤǡο}%en{The number of data elemnts int the data queue} */
} T_RDTQ;


/** %jp{᡼ܥå} */
typedef struct t_cmbx
{
	ATR		mbxatr;			/**< %jp{᡼ܥå°} */
	PRI		maxmpri;		/**< %jp{åͥ٤κ} */
	VP		mprihd;			/**< %jp{̤ͥΥå塼إåΰƬ} */
} T_CMBX;

/** %jp{᡼ܥå} */
typedef struct t_rmbx
{
	ID		wtskid;			/**< %jp{᡼ܥåԤƬΥIDֹ} */
	T_MSG	*pk_msg;		/**< %jp{å塼ƬΥåѥåȤƬ} */
} T_RMBX;



/** %jp{ߥ塼ƥå} */
typedef struct t_cmtx
{
	ATR		mtxatr;			/* ߥ塼ƥå° */
	PRI		ceilpri;		/* ߥ塼ƥåξͥ */
} T_CMTX;


/* åХåե־ */
typedef struct t_rmbf
{
	ID		stskid;			/* åХåեԤƬΥIDֹ */
	ID		rtskid;			/* åХåեμԤƬΥIDֹ */
	UINT	smsgcnt;		/* åХåեäƤåο */
	SIZE	fmbfsz;			/* åХåեΰζΰΥ(Хȿ¤δΰ) */
} T_RMBF;


/** %jp{Ĺס} */
typedef struct t_cmpf
{
	ATR		mpfatr;			/**< %jp{Ĺס°} */
	UINT	blkcnt;			/**< %jp{Ǥ֥å(Ŀ)} */
	UINT	blksz;			/**< %jp{֥åΥ(Хȿ)} */
	VP		mpf;			/**< %jp{ĹסΰƬ} */
} T_CMPF;


/** %jp{Ĺס} */
typedef struct t_rmpf
{
	ID		wtskid;			/**< %jp{ĹסԤƬΥIDֹ} */
	UINT	fblkcnt;		/**< %jp{Ĺסζ֥å(Ŀ)} */
} T_RMPF;


/** %jp{ϥɥ} */
typedef struct t_ccyc
{
	ATR		cycatr;			/**< %jp{ϥɥ°} */
	VP_INT	exinf;			/**< %jp{ϥɥγĥ} */
	FP		cychdr;			/**< %jp{ϥɥεư} */
	RELTIM	cyctim;			/**< %jp{ϥɥεư} */
	RELTIM	cycphs;			/**< %jp{ϥɥεư} */
} T_CCYC;


/** %jp{ϥɥ} */
typedef struct t_rcyc
{
	STAT	cycatr;			/**< %jp{ϥɥư} */
	RELTIM	lefttim;		/**< %jp{ϥɥ򼡤˵ưޤǤλ} */
} T_RCYC;


/* ߥϥɥ */
typedef struct t_dinh
{
	ATR		inhatr;			/* ߥϥɥ° */
	FP		inthdr;			/* ߥϥɥεư */
} T_DINH;


/* ߥӥ롼 */
typedef struct t_cisr
{
	ATR    isratr;			/* ߥӥ롼° */
	VP_INT exinf;			/* ߥӥ롼γĥ */
	INTNO  intno;			/* ߥӥ롼ղäֹ */
	FP     isr;				/* ߥӥ롼εư */
} T_CISR;



#ifdef __cplusplus
extern "C" {
#endif

/* %jp{OSεư}%en{Kernel Management Functions} */
ER      vsta_knl(void);										/**< %jp{ͥγ(ȼӥ)}%en{Start Kernel(HOS original)} */

/* %jp{ǽ}%en{Task Management Functions} */
ER      cre_tsk(ID tskid, const T_CTSK *pk_ctsk);			/**< %jp{}%en{Create Task} */
ER_ID   acre_tsk(const T_CTSK *pk_ctsk);					/**< %jp{(IDֹ漫ưդ)}%en{Create Task(ID Number Automatic Assignment)} */
ER      del_tsk(ID tskid);									/**< %jp{κ}%en{Delete Task} */
ER      act_tsk(ID tskid);									/* %jp{εư}%en{Activate Task} */
ER      iact_tsk(ID tskid);									/* εư(󥿥ƥ) */
ER_UINT can_act(ID tskid);									/* ư׵Υ󥻥 */
ER      sta_tsk(ID tskid, VP_INT stacd);					/* εư(ưɻ) */
void    ext_tsk(void);										/* νλ */
void    exd_tsk(void);										/* νλȺ */
ER      ter_tsk(ID tskid);									/* ζλ */
ER      chg_pri(ID tskid, PRI tskpri);						/* ͥ٤ѹ */
ER      get_pri(ID tskid, PRI *p_tskpri);					/* ͥ٤λ */
ER      ref_tsk(ID tskid, T_RTSK *p_rtsk);					/* ξֻ */
ER      ref_tst(ID tskid, T_RTST *p_rtst);					/* ξֻ(ʰ) */

/* °Ʊǽ */
ER      slp_tsk(void);										/* εԤ */
ER      tslp_tsk(TMO tmout);								/* εԤ(ॢȤ) */
ER      wup_tsk(ID tskid);									/* ε */
ER      iwup_tsk(ID tskid);									/* ε(󥿥ƥ) */
ER_UINT can_wup(ID tskid);									/* ׵Υ󥻥 */
ER      rel_wai(ID tskid);									/* Ԥ֤ζ */
ER      irel_wai(ID tskid);									/* Ԥ֤ζ(󥿥ƥ) */
ER      sus_tsk(ID tskid);									/* Ԥ֤ؤΰܹ */
ER      rsm_tsk(ID tskid);									/* Ԥ֤κƳ */
ER      frsm_tsk(ID tskid);									/* Ԥ֤ζƳ */
ER      dly_tsk(RELTIM dlytim);								/* ٱ */

/* 㳰ǽ */
ER      def_tex(ID tskid, T_DTEX *pk_dtex);					/* %jp{㳰롼} */
ER      ras_tex(ID tskid, TEXPTN rasptn);					/* %jp{㳰׵} */
ER      dis_tex(void);										/* %jp{㳰ζػ} */
ER      ena_tex(void);										/* %jp{㳰ζػ} */
BOOL    sns_tex(void);										/* %jp{㳰ػ߾֤λ} */

/* %jp{ޥե}%en{Semphores} */
ER      cre_sem(ID semid, const T_CSEM *pk_csem);			/**< %jp{ޥե}%en{Create Semaphore} */
ER_ID   acre_sem(const T_CSEM *pk_csem);					/**< %jp{ޥե(IDֹ漫ưդ)}%en{Create Semaphore(ID Number Automatic Assignment)} */
ER      del_sem(ID semid);									/**< %jp{ޥեκ}%en{Delete Semaphore} */
ER      sig_sem(ID semid);									/**< %jp{ޥե񸻤ֵ}%en{Release Semaphore Resource} */
ER      isig_sem(ID semid);									/**< %jp{ޥե񸻤ֵ(󥿥ƥ)}%en{Release Semaphore Resource} */
ER      wai_sem(ID semid);									/**< %jp{ޥե񸻤γ}%en{Acquire Semaphore Resource} */
ER      pol_sem(ID semid);									/**< %jp{ޥե񸻤γ(ݡ)}%en{Acquire Semaphore Resource(Polling)} */
ER      twai_sem(ID semid, TMO tmout);						/**< %jp{ޥե񸻤γ(ॢȤ)}%en{Acquire Semaphore Resource(with Timeout)} */
ER      ref_sem(ID semid, T_RSEM *pk_rsem);					/**< %jp{ޥեξֻ}%en{Reference Semaphore State} */

/* %jp{٥ȥե饰}%en{Eventflags} */
ER      cre_flg(ID flgid, const T_CFLG *pk_cflg);			/**< %jp{٥ȥե饰}%en{Create Eventflag} */
ER_ID   acre_flg(const T_CFLG *pk_cflg);					/**< %jp{٥ȥե饰(IDֹ漫ư)}%en{Create Eventflag(ID Number Automatic Assignment)} */
ER      del_flg(ID flgid);									/**< %jp{٥ȥե饰κ}%en{Delete Eventflag} */
ER      set_flg(ID flgid, FLGPTN setptn);					/**< %jp{٥ȥե饰Υå}%en{Set Eventflag} */
ER      iset_flg(ID flgid, FLGPTN setptn);					/**< %jp{٥ȥե饰Υå(󥿥ƥ)}%en{Set Eventflag} */
ER      clr_flg(ID flgid, FLGPTN clrptn);					/**< %jp{٥ȥե饰Υꥢ}%en{Clear Eventflag} */
ER      wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/**< %jp{٥ȥե饰Ԥ}%en{Wait for Eventflag} */
ER      pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/**< %jp{٥ȥե饰Ԥ(ݡ)}%en{Wait for Eventflag(Polling)} */
ER      twai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn, TMO tmout);
															/**< %jp{٥ȥե饰Ԥ(ॢȤ)}%en{Wait for Eventflag(with Timeout)} */
ER      ref_flg(ID flgid, T_RFLG *pk_rflg);					/**< %jp{٥ȥե饰ξֻ}%en{Reference Eventflag State} */

/* %jp{ǡ塼}%en{Data queue} */
ER      cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);			/**< %jp{ǡ塼} */
ER_ID   acre_dtq(const T_CDTQ *pk_cdtq);					/**< %jp{ǡ塼(IDֹ漫ưդ)} */
ER      kernel_cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);	/**< %jp{ǡ塼(ͥؿ)} */
ER      del_dtq(ID dtqid);									/**< %jp{ǡ塼κ} */
ER      snd_dtq(ID dtqid, VP_INT data);						/**< %jp{ǡ塼ؤ} */
ER      psnd_dtq(ID dtqid, VP_INT data);					/**< %jp{ǡ塼ؤ(ݡ)} */
ER      ipsnd_dtq(ID dtqid, VP_INT data);					/**< %jp{ǡ塼ؤ(ݡ 󥿥ƥ)} */
ER      tsnd_dtq(ID dtqid, VP_INT data, TMO tmout);			/**< %jp{ǡ塼ؤ(ॢȤ)} */
ER      fsnd_dtq(ID dtqid, VP_INT data);					/**< %jp{ǡ塼ؤζ} */
#define ifsnd_dtq	fsnd_dtq								/**< %jp{ǡ塼ؤζ(󥿥ƥѥޥ)} */
ER      rcv_dtq(ID dtqid, VP_INT *p_data);					/**< %jp{ǡ塼μ} */
ER      prcv_dtq(ID dtqid, VP_INT *p_data);					/**< %jp{ǡ塼μ(ݡ)} */
ER      trcv_dtq(ID dtqid, VP_INT *p_data, TMO tmout);		/**< %jp{ǡ塼μ(ॢȤ)} */
ER      ref_dtq(ID dtqid, T_RDTQ *pk_rdtq);					/**< %jp{ǡ塼ξֻ} */

/* %jp{᡼ܥå}%en{Mailboxes} */
ER      cre_mbx(ID semid, const T_CMBX *pk_cmbx);			/**< %jp{᡼ܥå} */
ER_ID   acre_mbx(const T_CMBX *pk_cmbx);					/**< %jp{᡼ܥå(IDֹ漫ưդ)} */
ER      del_mbx(ID semid);									/**< %jp{᡼ܥåκ} */
ER      snd_mbx(ID mbxid, T_MSG *pk_msg);					/**< %jp{᡼ܥåؤ} */
ER      rcv_mbx(ID mbxid, T_MSG **ppk_msg);					/**< %jp{᡼ܥåμ} */
ER      prcv_mbx(ID mbxid, T_MSG **ppk_msg);				/**< %jp{᡼ܥåμ(ݡ)} */
ER      trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout);		/**< %jp{᡼ܥåμ(ॢȤ)} */
ER      ref_mbx(ID mbxid, T_RMBX *pk_rmbx);					/**< %jp{᡼ܥåξֻ} */

/* %jp{ߥ塼ƥå} */
ER      cre_mtx(ID mtxid, const T_CMTX *pk_cmtx);			/**< %jp{ߥ塼ƥå}%en{Create Mutex} */
ER_ID   acre_mtx(const T_CMTX *pk_cmtx);					/**< %jp{ߥ塼ƥå(IDֹ漫ưդ)}%en{Create Mutex(ID Number Automatic Assignment)} */
ER      del_mtx(ID mtxid);									/**< %jp{ߥ塼ƥåκ}%en{Delete Mutex} */
ER      loc_mtx(ID mtxid);									/**< %jp{ߥ塼ƥåΥå} */
ER      ploc_mtx(ID mtxid);									/**< %jp{ߥ塼ƥåΥå(ݡ)} */
ER      tloc_mtx(ID mtxid, TMO tmout);						/**< %jp{ߥ塼ƥåΥå(ॢȤ)} */
ER      unl_mtx(ID mtxid);									/**< %jp{ߥ塼ƥåΥå} */


/* %jp{Ĺס} */
ER      cre_mpf(ID mpfid, const T_CMPF *pk_cmpf);			/**< %jp{Ĺס} */
ER_ID   acre_mpf(const T_CMPF *pk_cmpf);					/**< %jp{Ĺס(IDֹ漫ưդ)} */
ER      del_mpf(ID mpfid);									/**< %jp{Ĺסκ} */
ER      get_mpf(ID mpfid, VP *p_blk);						/**< %jp{Ĺ֥åγ} */
ER      pget_mpf(ID mpfid, VP *p_blk);						/**< %jp{Ĺ֥åγ(ݡ)} */
ER      tget_mpf(ID mpfid, VP *p_blk, TMO tmout);			/**< %jp{Ĺ֥åγ(ॢȤ)} */
ER      rel_mpf(ID mpfid, VP blk);							/**< %jp{Ĺ֥åֵ} */
ER      ref_mpf(ID mpfid, T_RMPF *pk_rmpf);					/**< %jp{Ĺ֥åξֻ} */


/* %jp{ƥִǽ}%en{System Time Management} */
ER      set_tim(const SYSTIM *p_system);					/**< %jp{ƥ}%en{Set System Time} */
ER      get_tim(SYSTIM *p_system);							/**< %jp{ƥλ}%en{Reference System Time} */
ER      isig_tim(void);										/**< %jp{ƥåζ}%en{Supply Time Tick} */

/* %jp{ϥɥ} */
ER      cre_cyc(ID cycid, const T_CCYC *pk_ccyc);			/**< %jp{ϥɥ} */
ER_ID   acre_cyc(const T_CCYC *pk_ccyc);					/**< %jp{ϥɥ(IDֹ漫ưդ)} */
ER      del_cyc(ID cycid);									/**< %jp{ϥɥκ} */
ER      sta_cyc(ID cycid);									/**< %jp{ϥɥư} */
ER      stp_cyc(ID cycid);									/**< %jp{ϥɥư} */
ER      ref_cyc(ID cycid, T_RCYC *pk_rcyc);					/**< %jp{ϥɤξֻ} */

/* ƥִǽ */
ER      rot_rdq(PRI tskpri);								/**< %jp{̤ͥβž} */
ER      get_tid(ID *p_tskid);								/**< %jp{¹Ծ֥IDλ} */
ER      loc_cpu(void);										/**< %jp{CPUå֤ؤΰܹ} */
#define iloc_cpu	loc_cpu
ER      unl_cpu(void);										/**< %jp{CPUå֤β} */
#define iunl_cpu	unl_cpu
ER      dis_dsp(void);										/**< %jp{ǥѥåζػ} */
ER      ena_dsp(void);										/**< %jp{ǥѥåε} */
BOOL    sns_ctx(void);										/**< %jp{ƥȤλ} */
BOOL    sns_loc(void);										/**< %jp{CPUå֤λ} */
BOOL    sns_dsp(void);										/**< %jp{ǥѥåػ߾֤λ} */
BOOL    sns_dpn(void);										/**< %jp{ ǥѥåα֤λ} */


ER      def_inh(INHNO inhno, const T_DINH *pk_dinh);
ER      cre_isr(ID isrid, const T_CISR *pk_cisr);			/**< %jp{ߥӥ롼} */
ER_ID   acre_isr(const T_CISR *pk_cisr);					/**< %jp{ߥӥ롼(IDֹ漫ưդ)} */
ER      del_isr(ID isrid);									/**< %jp{ߥӥ롼κ} */


ER      dis_int(INTNO intno);								/**< %jp{ߤζػ} */
ER      ena_int(INTNO intno);								/**< %jp{ߤε} */
ER      vclr_int(INTNO intno);								/**< %jp{װΥꥢ(ȼӥ)} */
ER      chg_imsk(INT imsk);									/**< %jp{ߥޥѹ(¸ӥ)} */
ER      get_imsk(INT *p_imsk);								/**< %jp{ߥޥλ(¸ӥ)} */
ER      vchg_ilv(INTNO intno, INT ilv);						/**< %jp{ߥ٥ѹ(ȼӥ)} */
ER      vget_ilv(INTNO intno, INT *p_ilv);					/**< %jp{ߥ٥뻲(ȼӥ)} */


/* %jp{ƥ๽ǽ} */
ER      ref_ver(T_RVER *pk_rver);							/**< %jp{Сֹλ} */


/* %jp{ͥեåؿ} */
void    _kernel_tsk_swi(ID tskid_old, ID tskid_new);		/**< %jp{åΥեå} */
void    _kernel_inh_sta(INHNO inhno);						/**< %jp{ߥϥɥ鳫ϤΥեå} */
void    _kernel_inh_end(INHNO inhno);						/**< %jp{ߥϥɥ齪λΥեå} */
void    _kernel_isr_sta(INTNO intno);						/**< %jp{ߥӥ롼󳫻ϤΥեå} */
void    _kernel_isr_end(INTNO intno);						/**< %jp{ߥӥ롼λΥեå} */


#ifdef __cplusplus
}
#endif


#endif /* _KERNEL__kernel_h__ */



/* end of file */
