/**
 *  Hyper Operating System V4 Advance
 *
 * @file  flgobj.h
 * @brief %jp{٥ȥե饰ȤΥإåե}%en{Eventflag object heder file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__object__flgobj_h__
#define _KERNEL__object__flgobj_h__



/* ------------------------------------------ */
/*  type definition                           */
/* ------------------------------------------ */

/* %jp{ե饰ѥѤη} */
#if _KERNEL_FLGCB_BITFIELD		/* %jp{FLGCB˥ӥåȥեɤѤ} */

#if _KERNEL_PROCATR_SIGNED_INT && !_KERNEL_OPT_CB_SIZE	/* %jp{ͥξ1bit䤷դȤ} */
typedef signed int						_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef signed int						_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#define _KERNEL_FLGCB_TBITDEF_FLGPTN	: _KERNEL_FLG_TBIT_FLGPTN + 1	/**< %jp{ե饰ѥΥӥåȥե} */
#else
typedef unsigned int					_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef unsigned int					_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#define _KERNEL_FLGCB_TBITDEF_FLGPTN	: _KERNEL_FLG_TBIT_FLGPTN		/**< %jp{ե饰ѥΥӥåȥե} */
#endif

#else							/* %jp{FLGCB˥ӥåȥեɤѤʤ} */

#if _KERNEL_FLG_TBIT_FLGPTN <= 7 && _KERNEL_PROCATR_SIGNED_INT
typedef _KERNEL_T_FAST_B				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_B				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#elif _KERNEL_FLG_TBIT_FLGPTN <= 8 && !(_KERNEL_PROCATR_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UB				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_UB				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#elif _KERNEL_FLG_TBIT_FLGPTN <= 15 && _KERNEL_PROCATR_SIGNED_INT
typedef _KERNEL_T_FAST_H				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_H				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#elif _KERNEL_FLG_TBIT_FLGPTN <= 16 && !(_KERNEL_PROCATR_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UH				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_UH				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#elif _KERNEL_FLG_TBIT_FLGPTN <= 31 && _KERNEL_PROCATR_SIGNED_INT
typedef _KERNEL_T_FAST_W				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_W				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#elif _KERNEL_FLG_TBIT_FLGPTN <= 32 && !(_KERNEL_PROCATR_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UW				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_UW				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#elif _KERNEL_FLG_TBIT_FLGPTN <= 63 && _KERNEL_PROCATR_SIGNED_INT
typedef _KERNEL_T_FAST_D				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_D				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#else
typedef _KERNEL_T_FAST_UD				_KERNEL_FLG_T_FLGPTN;			/**< %jp{ե饰ѥ黻Ȥη} */
typedef _KERNEL_T_LEAST_UD				_KERNEL_FLGCB_T_FLGPTN;			/**< %jp{ե饰ѥFLGCB˳ǼȤη} */
#endif

#define _KERNEL_FLGCB_TBITDEF_FLGPTN									/**< %jp{ե饰ѥΥӥåȥե} */

#endif


/* %jp{٥ȥե饰°Ѥη(4bitɬ)} */
#if _KERNEL_FLGCB_BITFIELD		/* %jp{FLGCB˥ӥåȥեɤѤ} */

#if _KERNEL_PROCATR_SIGNED_INT && !_KERNEL_LEAST_CB_SIZE	/* %jp{ͥξ1bit䤷դȤ} */
typedef signed int						_KERNEL_FLG_T_FLGATR;			/**< %jp{٥ȥե饰°黻Ȥη} */
typedef signed int						_KERNEL_FLGCB_T_FLGATR;			/**< %jp{٥ȥե饰°FLGCB˳ǼȤη} */
#define _KERNEL_FLGCB_TBITDEF_FLGATR	: 4 + 1							/**< %jp{٥ȥե饰°Υӥåȥե} */
#else
typedef unsigned int					_KERNEL_FLG_T_FLGATR;			/**< %jp{٥ȥե饰°黻Ȥη} */
typedef unsigned int					_KERNEL_FLGCB_T_FLGATR;			/**< %jp{٥ȥե饰°FLGCB˳ǼȤη} */
#define _KERNEL_FLGCB_TBITDEF_FLGATR	: 4								/**< %jp{٥ȥե饰°Υӥåȥե} */
#endif

#else							/* %jp{FLGCB˥ӥåȥեɤѤʤ} */

#if _KERNEL_PROCATR_SIGNED_INT
typedef _KERNEL_T_FAST_B				_KERNEL_FLG_T_FLGATR;			/**< %jp{٥ȥե饰°黻Ȥη} */
typedef _KERNEL_T_LEAST_B				_KERNEL_FLGCB_T_FLGATR;			/**< %jp{٥ȥե饰°FLGCB˳ǼȤη} */
#else
typedef _KERNEL_T_FAST_UB				_KERNEL_FLG_T_FLGATR;			/**< %jp{٥ȥե饰°黻Ȥη} */
typedef _KERNEL_T_LEAST_UB				_KERNEL_FLGCB_T_FLGATR;			/**< %jp{٥ȥե饰°FLGCB˳ǼȤη} */
#endif

#define _KERNEL_FLGCB_TBITDEF_FLGATR									/**< %jp{٥ȥե饰°Υӥåȥե} */

#endif


/** %jp{Ԥե饰¤} */
typedef struct _kernel_t_flginf
{
	MODE   wfmode;		/**< %jp{Ԥ⡼} */
	FLGPTN waiptn;		/**< %jp{Ԥӥåȥѥʲѥȷ)} */
} _KERNEL_T_FLGINF;



/* ------------------------------------------ */
/*  Control block                             */
/* ------------------------------------------ */

#if _KERNEL_FLGCB_SPLIT_RO


/** %jp{٥ȥե饰ȥ֥å(꡼ɥ꡼)}%en{Eventflag Control Block(read-only)} */
typedef struct _kernel_t_flgcb_ro
{
#if _KERNEL_FLGCB_FLGATR
	_KERNEL_FLGCB_T_FLGATR	flgatr		_KERNEL_FLGCB_TBITDEF_FLGPTN;		/**< %jp{٥ȥե饰°} */
#endif
} _KERNEL_FLGCB_T_RO;

/** %jp{٥ȥե饰ȥ֥å}%en{Eventflag Control Block} */
typedef struct _kernel_t_flgcb
{
#if _KERNEL_FLGCB_QUE
	_KERNEL_T_QUE			que;											/**< %jp{Ԥ} */
#endif

#if _KERNEL_FLGCB_FLGPTN
	_KERNEL_FLGCB_T_FLGPTN	flgptn		_KERNEL_FLGCB_TBITDEF_FLGPTN;		/**< %jp{٥ȥե饰Υӥåȥѥ} */
#endif
} _KERNEL_T_FLGCB;


#else


/** %jp{٥ȥե饰ȥ֥å} */
typedef struct _kernel_t_flgcb
{
#if _KERNEL_FLGCB_QUE
	_KERNEL_T_QUE			que;											/**< %jp{Ԥ} */
#endif

#if _KERNEL_FLGCB_FLGPTN
	_KERNEL_FLGCB_T_FLGPTN	flgptn		_KERNEL_FLGCB_TBITDEF_FLGPTN;		/**< %jp{٥ȥե饰Υӥåȥѥ} */
#endif

#if _KERNEL_FLGCB_FLGATR
	_KERNEL_FLGCB_T_FLGATR	flgatr		_KERNEL_FLGCB_TBITDEF_FLGPTN;		/**< %jp{٥ȥե饰°} */
#endif
} _KERNEL_T_FLGCB;

typedef _KERNEL_T_FLGCB		_KERNEL_T_FLGCB_RO;


#endif



/* ------------------------------------------ */
/*  ID range                                  */
/* ------------------------------------------ */

extern const ID							_kernel_max_flgid;										/**< %jp{٥ȥե饰IDκ} */

#define _KERNEL_FLG_TMIN_ID				1														/**< %jp{٥ȥե饰IDκǾ} */
#define _KERNEL_FLG_TMAX_ID				(_kernel_max_flgid)										/**< %jp{٥ȥե饰IDκ} */

#define _KERNEL_FLG_CHECK_FLGID(flgid)	((flgid) >= _KERNEL_FLG_TMIN_ID && (flgid) <= _KERNEL_FLG_TMAX_ID)



/* ------------------------------------------ */
/*  Control block tables                      */
/* ------------------------------------------ */


#if _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_BLKARRAY
#if _KERNEL_FLGCB_SPLIT_RO

/* %jp{֥åROʬΥξ}%en{block array} */
extern  _KERNEL_T_FLGCB					_kernel_flgcb_tbl[];									/**< %jp{٥ȥե饰ȥ֥åơ֥} */
extern const _KERNEL_T_FLGCB_RO			_kernel_flgcb_ro_tbl[];									/**< %jp{٥ȥե饰ȥ֥å(꡼ɥ꡼)ơ֥} */
#define _KERNEL_FLG_ID2FLGCB(flgid)		(&_kernel_flgcb_tbl[(flgid) - _KERNEL_FLG_TMIN_ID])		/**< %jp{ȥ֥åμ} */
#define _KERNEL_FLG_CHECK_EXS(flgid)	(_kernel_flgcb_ro_tbl[(flgid) - _KERNEL_FLG_TMIN_ID].flgatr & _KERNEL_FLG_TA_CRE)
																								/**< %jp{֥Ȥ¸ߥå} */
#define _KERNEL_FLG_TA_CRE				0x08													/**< %jp{flgatrΥӥåȤѤbit} */

#else

/* %jp{֥åξ}%en{block array} */
extern  _KERNEL_T_FLGCB					_kernel_flgcb_tbl[];									/**< %jp{٥ȥե饰ȥ֥åơ֥} */
#define _KERNEL_FLG_ID2FLGCB(flgid)		(&_kernel_flgcb_tbl[(flgid) - _KERNEL_FLG_TMIN_ID])		/**< %jp{ȥ֥åμ} */
#define _KERNEL_FLG_CHECK_EXS(flgid)	(_kernel_flgcb_tbl[(flgid) - _KERNEL_FLG_TMIN_ID].flgatr & _KERNEL_FLG_TA_CRE)
																								/**< %jp{֥Ȥ¸ߥå} */
#define _KERNEL_FLG_TA_CRE				0x08													/**< %jp{flgatrΥӥåȤѤbit} */

#endif

#elif _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_PTRARRAY

/* %jp{ݥξ}%en{pointer array} */
extern  _KERNEL_T_FLGCB					*_kernel_flgcb_tbl[];									/**< %jp{٥ȥե饰ȥ֥åơ֥} */
#define _KERNEL_FLG_ID2FLGCB(flgid)		(_kernel_flgcb_tbl[(flgid) - _KERNEL_FLG_TMIN_ID])		/**< %jp{٥ȥե饰IDFLGCB ɥ쥹} */
#define _KERNEL_FLG_CHECK_EXS(flgid)	(_KERNEL_FLG_ID2FLGCB(flgid) != NULL)					/**< %jp{֥Ȥ¸ߥå} */
#define _KERNEL_FLG_TA_CRE				0

#endif



/* ------------------------------------------ */
/*   Accessor for FLGCB                       */
/* ------------------------------------------ */

/* flgcb_ro */
#if !_KERNEL_FLGCB_SPLIT_RO								
#define _KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)	(flgcb)
#else
#if _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_BLKARRAY		/* %jp{FLGCBñǴ}%en{array of block} */
#define _KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)	(&_kernel_flgcb_ro_tbl[(flgid)])
#elif _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_PTRARRAY		/* %jp{FLGCBݥǴ}%en{array of pointer} */
#define _KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)	((flgcb)->flgcb_ro)
#endif
#endif


/* que */
#define _KERNEL_FLG_GET_QUE(flgcb)				(&(flgcb)->que)

/* flgptn */
#if _KERNEL_FLGCB_FLGPTN
#define _KERNEL_FLG_SET_FLGPTN(flgcb, x)		do { (flgcb)->flgptn = (_KERNEL_FLGCB_T_FLGPTN)(x); } while (0)
#define _KERNEL_FLG_GET_FLGPTN(flgcb)			((_KERNEL_FLG_T_FLGPTN)(flgcb)->flgptn)
#else
#define _KERNEL_FLG_SET_FLGPTN(flgcb, x)		do { } while (0)
#define _KERNEL_FLG_GET_FLGPTN(flgcb)			(0)
#endif

/* flgatr */
#if _KERNEL_FLGCB_FLGATR
#define _KERNEL_FLG_SET_FLGATR(flgcb_ro, x)		do { (flgcb_ro)->flgatr = (_KERNEL_FLGCB_T_FLGATR)(x); } while (0)
#define _KERNEL_FLG_GET_FLGATR(flgcb_ro)		((_KERNEL_FLG_T_FLGATR)(flgcb_ro)->flgatr)
#else
#define _KERNEL_FLG_SET_FLGATR(flgcb_ro, x)		do { } while (0)
#if _KERNEL_SPT_FLG_TA_TFIFO
#define _KERNEL_FLG_GET_FLGATR(flgcb_ro)		(TA_TFIFO)
#else
#define _KERNEL_FLG_GET_FLGATR(flgcb_ro)		(TA_TPRI)
#endif
#endif



/* ------------------------------------------ */
/*   Macro functions                          */
/* ------------------------------------------ */

/* %jp{塼³} */
#if _KERNEL_SPT_FLG_TA_TFIFO && _KERNEL_SPT_FLG_TA_TPRI		/* %jp{TA_TFIFO  TA_TPRI κ } */
#define _KERNEL_FLG_ADD_QUE(flgcb, flgcb_ro, tskhdl)	_KERNEL_ADD_QUE(_KERNEL_FLG_GET_QUE(flgcb), tskhdl, _KERNEL_FLG_GET_FLGATR(flgcb_ro))
#elif _KERNEL_SPT_FLG_TA_TFIFO && !_KERNEL_SPT_SE_TA_TPRI	/* %jp{TA_TFIFO Τ } */
#define _KERNEL_FLG_ADD_QUE(flgcb, flgcb_ro, tskhdl)	_KERNEL_ADF_QUE(_KERNEL_FLG_GET_QUE(flgcb), tskhdl)
#elif !_KERNEL_SPT_FLG_TA_TFIFO && _KERNEL_SPT_FLG_TA_TPRI	/* %jp{TA_TPRI Τ } */
#define _KERNEL_FLG_ADD_QUE(flgcb, flgcb_ro, tskhdl)	_KERNEL_ADP_QUE(_KERNEL_FLG_GET_QUE(flgcb), tskhdl)
#else
#error error:_KERNEL_SPT_FLG_TA_TPRI and _KERNEL_SPT_FLG_TA_TFIFO
#endif

/* %jp{塼곰} */
#define _KERNEL_FLG_RMV_QUE(flgcb, tskhdl)	_KERNEL_RMV_QUE(_KERNEL_FLG_GET_QUE(flgcb), tskhdl)

/* %jp{塼ƬФ} */
#define _KERNEL_FLG_RMH_QUE(flgcb)			_KERNEL_RMH_QUE(_KERNEL_FLG_GET_QUE(flgcb))

/* %jp{ॢȥ塼³} */
#if _KERNEL_SPT_TWAI_FLG	/* %jp{twai_semݡȻϥॢȥ塼θ} */
#define _KERNEL_FLG_ADD_TOQ(tskhdl, tmout)	_KERNEL_SYS_ADD_TOQ(tskhdl, tmout)
#else
#define _KERNEL_FLG_ADD_TOQ(tskhdl)			do { } while (0)
#endif

/* %jp{ॢȥ塼} */
#if _KERNEL_SPT_TWAI_FLG	/* %jp{twai_flgݡȻϥॢȥ塼θ} */
#define _KERNEL_FLG_RMV_TOQ(tskhdl)			_KERNEL_SYS_RMV_TOQ(tskhdl)
#else
#define _KERNEL_FLG_RMV_TOQ(tskhdl)			do { } while (0)
#endif



/* ------------------------------------------ */
/*   Functions                                */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

ER   _kernel_cre_flg(ID flgid, const T_CFLG *pk_cflg);
ER   _kernel_wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn, TMO tmout);
BOOL _kernel_chk_flg(_KERNEL_T_FLGCB *flgcb, _KERNEL_T_FLGINF *pk_flginf);

#ifdef __cplusplus
}
#endif



#endif	/* _KERNEL__object__flgobj_h__ */



/* end of file */
