/**
 *  Hyper Operating System V4 Advance
 *
 * @file  semobj.h
 * @brief %jp{ޥեȤΥإåե}%en{Semaphore object heder file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__object__semobj_h__
#define _KERNEL__object__semobj_h__



/* ------------------------------------------ */
/*  Primitive type definition                 */
/* ------------------------------------------ */

/* %jp{ޥեѤη} */
#if _KERNEL_SEMCB_BITFIELD		/* %jp{SEMCB˥ӥåȥեɤѤ} */

#if _KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE	/* %jp{ͥξ1bit䤷դȤ} */
typedef signed int						_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef signed int						_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#define _KERNEL_SEMCB_TBITDEF_SEMCNT	: (_KERNEL_SEM_TBIT_SEMCNT+1)	/**< %jp{ޥե󥿤Υӥåȥե} */
#else
typedef unsigned int					_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef unsigned int					_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#define _KERNEL_SEMCB_TBITDEF_SEMCNT	: _KERNEL_SEM_TBIT_SEMCNT		/**< %jp{ޥե󥿤Υӥåȥե} */
#endif

#else							/* %jp{SEMCB˥ӥåȥեɤѤʤ} */

#if (_KERNEL_SEM_TMAX_SEMCNT <= _KERNEL_TMAX_B) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_B				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_B				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#elif (_KERNEL_SEM_TMAX_SEMCNT <= _KERNEL_TMAX_UB) && !(_KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UB				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UB				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#elif (_KERNEL_SEM_TMAX_SEMCNT <= _KERNEL_TMAX_H) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_H				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_H				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#elif (_KERNEL_SEM_TMAX_SEMCNT <= _KERNEL_TMAX_UH) && !(_KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UH				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UH				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#elif (_KERNEL_SEM_TMAX_SEMCNT <= _KERNEL_TMAX_W) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_W				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_W				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#elif (_KERNEL_SEM_TMAX_SEMCNT <= _KERNEL_TMAX_UW) && !(_KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UW				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UW				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#elif (_KERNEL_SEM_TMAX_SEMCNT <= _KERNEL_TMAX_D) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_D				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_D				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#else
typedef _KERNEL_T_FAST_UD				_KERNEL_SEM_T_SEMCNT;			/**< %jp{ޥե󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UD				_KERNEL_SEMCB_T_SEMCNT;			/**< %jp{ޥե󥿤SEMCB˳ǼȤη} */
#endif
#define _KERNEL_SEMCB_TBITDEF_SEMCNT									/**< %jp{ޥե󥿤Υӥåȥե} */

#endif


/* %jp{ޥե°Ѥη} */
#if _KERNEL_SEMCB_BITFIELD		/* %jp{SEMCB˥ӥåȥեɤѤ} */

/* %jp{TA_TFIFO  TA_TPRI Ƚ 1bit ɬ} */
typedef unsigned int					_KERNEL_SEM_T_SEMATR;
typedef unsigned int					_KERNEL_SEMCB_T_SEMATR;
#define _KERNEL_SEMCB_TBITDEF_SEMATR	: 1

#else							/* %jp{SEMCB˥ӥåȥեɤѤʤ} */

typedef _KERNEL_T_FAST_UB				_KERNEL_SEM_T_SEMATR;
typedef _KERNEL_T_LEAST_UB				_KERNEL_SEMCB_T_SEMATR;
#define _KERNEL_SEMCB_TBITDEF_SEMATR

#endif



/* ------------------------------------------ */
/*  Control block                             */
/* ------------------------------------------ */

#if _KERNEL_SEMCB_SPLIT_RO


/** %jp{ޥեȥ֥å(꡼ɥ꡼)}%en{Semaphore Control Block(read-only)} */
typedef struct _kernel_t_semcb_ro
{
#if _KERNEL_SEMCB_SEMATR
	_KERNEL_SEMCB_T_SEMATR	sematr		_KERNEL_SEMCB_TBITDEF_SEMATR;		/**< %jp{ޥե°} */
#endif

#if _KERNEL_SEMCB_MAXSEM
	_KERNEL_SEMCB_T_SEMCNT	maxsem		_KERNEL_SEMCB_TBITDEF_SEMCNT;		/**< %jp{ޥեκ񸻿} */
#endif
} _KERNEL_T_SEMCB_RO;

typedef const _KERNEL_T_SEMCB_RO	*_KERNEL_T_SEMCB_RO_PTR;


/** %jp{ޥեȥ֥å}%en{Semaphore Control Block} */
typedef struct _kernel_t_semcb
{
#if _KERNEL_SEMCB_QUE
	_KERNEL_T_QUE			que;											/**< %jp{ޥեԤ塼} */
#endif

#if _KERNEL_SEMCB_SEMCNT
	_KERNEL_SEMCB_T_SEMCNT	semcnt		_KERNEL_SEMCB_TBITDEF_SEMCNT;		/**< %jp{ޥեλ񸻿} */
#endif


#if _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY
	_KERNEL_T_SEMCB_RO_PTR	semcb_ro;										/**< %jp{ޥեȥ֥åROؤΥݥ} */
#endif
} _KERNEL_T_SEMCB;

typedef _KERNEL_T_SEMCB				*_KERNEL_T_SEMCB_PTR;


#else


/** %jp{ޥեȥ֥å}%en{Semaphore Control Block} */
typedef struct _kernel_t_semcb
{
#if _KERNEL_SEMCB_QUE
	_KERNEL_T_QUE			que;											/**< %jp{ޥեԤ塼} */
#endif

#if _KERNEL_SEMCB_SEMCNT
	_KERNEL_SEMCB_T_SEMCNT	semcnt		_KERNEL_SEMCB_TBITDEF_SEMCNT;		/**< %jp{ޥեλ񸻿} */
#endif

#if _KERNEL_SEMCB_SEMATR
	_KERNEL_SEMCB_T_SEMATR	sematr		_KERNEL_SEMCB_TBITDEF_SEMATR;		/**< %jp{ޥե°} */
#endif

#if _KERNEL_SEMCB_MAXSEM
	_KERNEL_SEMCB_T_SEMCNT	maxsem		_KERNEL_SEMCB_TBITDEF_SEMCNT;		/**< %jp{ޥեκ񸻿} */
#endif
} _KERNEL_T_SEMCB;

typedef _KERNEL_T_SEMCB				_KERNEL_T_SEMCB_RO;
typedef const _KERNEL_T_SEMCB_RO	*_KERNEL_T_SEMCB_RO_PTR;
typedef _KERNEL_T_SEMCB				*_KERNEL_T_SEMCB_PTR;


#endif



/* ------------------------------------------ */
/*  ID range                                  */
/* ------------------------------------------ */

extern const ID							_kernel_max_semid;										/**< %jp{ޥեIDκ} */

#define _KERNEL_SEM_TMIN_ID				1														/**< %jp{ޥեIDκǾ} */
#define _KERNEL_SEM_TMAX_ID				(_kernel_max_semid)										/**< %jp{ޥեIDκ} */

#define _KERNEL_SEM_CHECK_SEMID(semid)	((semid) >= _KERNEL_SEM_TMIN_ID && (semid) <= _KERNEL_SEM_TMAX_ID)
																								/**< %jp{IDϰϥå} */


/* ------------------------------------------ */
/*  Control block tables                      */
/* ------------------------------------------ */

#if _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_BLKARRAY
#if _KERNEL_SEMCB_SPLIT_RO

/* %jp{֥åROʬΥξ}%en{block array} */
extern  _KERNEL_T_SEMCB					_kernel_semcb_tbl[];									/**< %jp{ޥեȥ֥åơ֥} */
extern const _KERNEL_T_SEMCB_RO			_kernel_semcb_ro_tbl[];									/**< %jp{ޥեȥ֥å(꡼ɥ꡼)ơ֥} */
#define _KERNEL_SEM_ID2SEMCB(semid)		(&_kernel_semcb_tbl[(semid) - _KERNEL_SEM_TMIN_ID])		/**< %jp{ȥ֥åμ} */
#define _KERNEL_SEM_CHECK_EXS(semid)	(_kernel_semcb_ro_tbl[(semid) - _KERNEL_SEM_TMIN_ID].maxsem > 0)				
																								/**< %jp{֥Ȥ¸ߥå} */

#else

/* %jp{֥åξ}%en{block array} */
extern  _KERNEL_T_SEMCB					_kernel_semcb_tbl[];									/**< %jp{ޥեȥ֥åơ֥} */
#define _KERNEL_SEM_ID2SEMCB(semid)		(&_kernel_semcb_tbl[(semid) - _KERNEL_SEM_TMIN_ID])		/**< %jp{ȥ֥åμ} */
#define _KERNEL_SEM_CHECK_EXS(semid)	(_kernel_semcb_tbl[(semid) - _KERNEL_SEM_TMIN_ID].maxsem > 0)				
																								/**< %jp{֥Ȥ¸ߥå} */

#endif

#elif _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY

/* %jp{ݥξ}%en{pointer array} */
extern  _KERNEL_T_SEMCB					*_kernel_semcb_tbl[];									/**< %jp{ޥեȥ֥åơ֥} */
#define _KERNEL_SEM_ID2SEMCB(semid)		(_kernel_semcb_tbl[(semid) - _KERNEL_SEM_TMIN_ID])		/**< %jp{ޥեIDSEMCB ɥ쥹} */
#define _KERNEL_SEM_CHECK_EXS(semid)	(_KERNEL_SEM_ID2SEMCB(semid) != NULL)					/**< %jp{֥Ȥ¸ߥå} */

#endif



/* ------------------------------------------ */
/*   Accessor for SEMCB                       */
/* ------------------------------------------ */

/* semcb_ro */
#if !_KERNEL_SEMCB_SPLIT_RO								
#define _KERNEL_SEM_GET_SEMCB_RO(semid, semcb)	(semcb)
#else
#if _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_BLKARRAY		/* %jp{SEMCBñǴ}%en{array of block} */
#define _KERNEL_SEM_GET_SEMCB_RO(semid, semcb)	(&_kernel_semcb_ro_tbl[(semid)])
#elif _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY		/* %jp{SEMCBݥǴ}%en{array of pointer} */
#define _KERNEL_SEM_GET_SEMCB_RO(semid, semcb)	((semcb)->semcb_ro)
#endif
#endif


/* que */
#define _KERNEL_SEM_GET_QUE(semcb)			(&(semcb)->que)


/* semcnt */
#if _KERNEL_SEMCB_SEMCNT
#define _KERNEL_SEM_SET_SEMCNT(semcb, x)	do { (semcb)->semcnt = (_KERNEL_SEMCB_T_SEMCNT)(x); } while (0)
#define _KERNEL_SEM_GET_SEMCNT(semcb)		((_KERNEL_SEM_T_SEMCNT)(semcb)->semcnt)
#else
#define _KERNEL_SEM_SET_SEMCNT(semcb, x)	do { } while (0)
#define _KERNEL_SEM_GET_SEMCNT(semcb)		(0)
#endif


/* sematr */
#if _KERNEL_SEMCB_SEMATR
#define _KERNEL_SEM_SET_SEMATR(semcb, x)	do { (semcb)->sematr = (_KERNEL_SEMCB_T_SEMATR)(x); } while (0)
#define _KERNEL_SEM_GET_SEMATR(semcb)		((_KERNEL_SEM_T_SEMATR)(semcb)->sematr)
#else
#define _KERNEL_SEM_SET_SEMATR(semcb, x)	do { } while (0)
#if _KERNEL_SPT_SEM_TA_TFIFO
#define _KERNEL_SEM_GET_SEMATR(semcb)		(TA_TFIFO)
#else
#define _KERNEL_SEM_GET_SEMATR(semcb)		(TA_TPRI)
#endif
#endif


/* maxsem */
#if _KERNEL_SEMCB_MAXSEM
#define _KERNEL_SEM_SET_MAXSEM(semcb_ro, x)	do { (semcb_ro)->maxsem = (_KERNEL_SEMCB_T_SEMCNT)(x); } while (0)
#define _KERNEL_SEM_GET_MAXSEM(semcb_ro)	((_KERNEL_SEM_T_SEMCNT)(semcb_ro)->maxsem)
#else
#define _KERNEL_SEM_SET_MAXSEM(semcb_ro, x)	do { } while (0)
#define _KERNEL_SEM_GET_MAXSEM(semcb_ro)	(_KERNEL_TMAX_MAXSEM)
#endif



/* ------------------------------------------ */
/*   Macro functions                          */
/* ------------------------------------------ */

/* %jp{塼³} */
#if _KERNEL_SPT_SEM_TA_TFIFO && _KERNEL_SPT_SEM_TA_TPRI		/* %jp{TA_TFIFO  TA_TPRI κ } */
#define _KERNEL_SEM_ADD_QUE(semcb, semcb_ro, tskhdl)	_KERNEL_ADD_QUE(_KERNEL_SEM_GET_QUE(semcb), tskhdl, _KERNEL_SEM_GET_SEMATR(semcb_ro))
#elif _KERNEL_SPT_SEM_TA_TFIFO && !_KERNEL_SPT_SE_TA_TPRI	/* %jp{TA_TFIFO Τ } */
#define _KERNEL_SEM_ADD_QUE(semcb, semcb_ro, tskhdl)	_KERNEL_ADF_QUE(_KERNEL_SEM_GET_QUE(semcb), tskhdl)
#elif !_KERNEL_SPT_SEM_TA_TFIFO && _KERNEL_SPT_SEM_TA_TPRI	/* %jp{TA_TPRI Τ } */
#define _KERNEL_SEM_ADD_QUE(semcb, semcb_ro, tskhdl)	_KERNEL_ADP_QUE(_KERNEL_SEM_GET_QUE(semcb), tskhdl)
#else
#error error:_KERNEL_SPT_SEM_TA_TPRI and _KERNEL_SPT_SEM_TA_TFIFO
#endif

/* %jp{塼곰} */
#define _KERNEL_SEM_RMV_QUE(semcb, tskhdl)	_KERNEL_RMV_QUE(_KERNEL_SEM_GET_QUE(semcb), tskhdl)

/* %jp{塼ƬФ} */
#define _KERNEL_SEM_RMH_QUE(semcb)			_KERNEL_RMH_QUE(_KERNEL_SEM_GET_QUE(semcb))


/* %jp{ॢȥ塼³} */
#if _KERNEL_SPT_TWAI_SEM	/* %jp{twai_semݡȻϥॢȥ塼θ} */
#define _KERNEL_SEM_ADD_TOQ(tskhdl, tmout)	_KERNEL_SYS_ADD_TOQ(tskhdl, tmout)
#else
#define _KERNEL_SEM_ADD_TOQ(tskhdl)			do { } while (0)
#endif

/* %jp{ॢȥ塼곰} */
#if _KERNEL_SPT_TWAI_SEM	/* %jp{twai_semݡȻϥॢȥ塼θ} */
#define _KERNEL_SEM_RMV_TOQ(tskhdl)			_KERNEL_SYS_RMV_TOQ(tskhdl)
#else
#define _KERNEL_SEM_RMV_TOQ(tskhdl)			do { } while (0)
#endif



/* ------------------------------------------ */
/*   Functions                                */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

ER _kernel_cre_sem(ID semid, const T_CSEM *pk_csem);	/**< %jp{ޥե}%en{Create Semaphore} */
ER _kernel_wai_sem(ID semid, TMO tmout);				/**< %jp{ޥե񸻤γ()}%en{Acquire Semaphore Resource} */

#ifdef __cplusplus
}
#endif



#endif	/* _KERNEL__object__semobj_h__ */


/* end of file */
