/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kexe_irc.c
 * @brief %jp{Analog Devices ADuC7000꡼ѳߥȥ}%en{Analog Devices ADuC7000 series}
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/inhobj.h"
#include "object/isrobj.h"


/** %jp{ߥȥγ߽} */
void _kernel_exe_irc(INHNO inhno)
{
	INTNO intno;
	UW    intsta;
	
	switch ( inhno )
	{
	case _KERNEL_ARM_INHNO_IRQ:
		intsta = *_KERNEL_IRC_IRQSTA;
		break;

	case _KERNEL_ARM_INHNO_FIQ:
		intsta = *_KERNEL_IRC_FIQSTA;
		break;
	
	default:
		return;
	}
	
	/* %jp{ֹ} */
	for ( intno = 0; intno <= 23; intno++ )
	{
		if ( intsta & 1 )
		{
			/* %jp{ߥӥ롼ƤӽФ} */
			_kernel_exe_isr(intno);
		}
		
		intsta >>= 1;
	}
}


/* end of file */
