/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  intc.h
 * @brief %jp{MN103Sѳߥȥ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/inhobj.h"
#include "object/isrobj.h"


/* IRQ߽ */
void _kernel_exe_irc(void)
{
	INTNO intno;
	UH    gicr;
	int   i;
	
	/* %jp{ֹ} */
	intno = *_KERNEL_MN103S_INTC_IAGR;
	gicr  = *_KERNEL_MN103S_INTC_GICR(intno);
	for ( i = 0; i < 4; i++ )
	{
		if ( gicr & 1 )
		{
			/* ߥӥ롼ƤӽФ */
			_kernel_exe_isr(intno);
		}
		intno++;
		gicr >>= 1;
	}
}


/* end of file */
