; --------------------------------------------------------------------------- 
;  Hyper Operating System V4 Advance
;   %en{IRQߥϥɥ(ARM v6 ƥ)}%jp{IRQ handler for ARM v6}
;
;  Copyright (C) 1998-2006 by Project HOS
;  http://sourceforge.jp/projects/hos/
; --------------------------------------------------------------------------- 


				INCLUDE	arm_v6.inc


				IMPORT	_kernel_ictxcb
				IMPORT	_kernel_sta_inh
				IMPORT	_kernel_end_inh
				IMPORT	_kernel_exe_inh
				EXPORT	_kernel_irq_hdr						; IRQϥɥ


				PRESERVE8
				AREA	code, CODE, READONLY
				CODE32

; ----------------------------------------------
;  IRQ ϥɥ
; ----------------------------------------------
_kernel_irq_hdr
			; ---- 쥸
				sub		lr, lr, #4								; ꥿󥢥ɥ쥹
				srsfd	#Mode_SYS!								; lr_irq, spsr_irqSYS⡼ɥå
				cps		#Mode_SYS								; SYS⡼ɤ˰ܹ
				stmfd	sp!, {r0-r3, r12, lr}					; ѥ쥸
				mrs		r2, cpsr								; cpsrr2
				cpsid	fi										; ߶ػ
				
			; ---- ߥޥ
				ldr		r0, =_kernel_ictxcb
				ldr		r3, [r0, #ICTXCB_IMSK]					; ŤimskͤФ
				and		r2, r2, #F_Bit:OR:I_Bit
				strb	r2, [r0, #ICTXCB_IMSK]					; cpsrͤimskͤ
				
			; ---- ¿ųȽ
				ldrb	r1, [r0, #ICTXCB_INTCNT]				; ߥͥȥͼ
				add		r1, r1, #1								; ߥͥȥ󥿥󥯥
				strb	r1, [r0, #ICTXCB_INTCNT]				; ߥͥȥ
				cmp		r1, #1
				bne		multiple_int							; ¿ųߤʤʬ
				
			; ---- SPߥƥȤΤΤؤ
				mov		r1, sp									; SP¸
				ldr		sp, [r0, #ICTXCB_ISP]					; ѥåڤؤ
				stmfd	sp!, {r1, r3}							; SPȵimask¸
				
			; ---- ߳Ͻ
				bl		_kernel_sta_inh							; ߳
				
			; ---- ߥϥɥ¹
				mov		r0, #INHNO_IRQ
				bl		_kernel_exe_inh
				
			; ---- ߽νλ
				ldmfd	sp!, {r1, r3}							; ѥ쥸
				mov		sp, r1									; SP򸵤ΥƥȤΤΤ᤹
				ldr		r0, =_kernel_ictxcb						; ߥͥȥ󥿤Υɥ쥹
				mov		r1, #0									; ߥͥȥ󥿤0᤹
				strb	r1, [r0, #ICTXCB_INTCNT]				; ߥͥȥ
			
			; ---- ߥޥ
				ldr		r1, [sp, #28]							; spsr_irq ͼФ
				and		r1, r1, #F_Bit:OR:I_Bit
				cmp		r1, r3									; imskͤ
				bne		return_int								; ԰פʤ齪λå
				strb	r3, [r0, #ICTXCB_IMSK]					; ޥ
				
			; ---- ߽λ
				bl		_kernel_end_inh							; ߽λ

				ldr		r0, =_kernel_ictxcb
				ldr		r1, [sp, #28]							; spsr_irq ͼФ
				ldrb	r0, [r0, #ICTXCB_IMSK]					; λǤimskͼФ
				bic		r1, r1, #F_Bit:OR:I_Bit
				and		r0, r0, #F_Bit:OR:I_Bit
				orr		r1, r1, r0
				str		r1, [sp, #28]							; spsr_irq imskȿ

return_int
			; ---- 
				ldmfd	sp!, {r0-r3, r12, lr}					; ѥ쥸
				rfefd	sp!										; ꥿


			; ---- ¿ų߽
multiple_int
			; ---- å8Хȥ饤Ȥ˰ư
				mov		r1,  sp									; ȯSYS⡼ɤSP8ܿݾڤʤΤ
				bic		sp, sp, #0x7
				stmfd	sp!, {r0, r1}							; SPѥå¸(8ܿˤʤ褦r1)
				
			; ---- ߥϥɥ¹
				mov		r0, #INHNO_IRQ
				bl		_kernel_exe_inh

			; ---- å饤
				ldmfd	sp!, {r0, r1}							; ѥ쥸
				mov		sp, r1
				
			; ---- ߥ
				ldrb	r1, [r0, #ICTXCB_INTCNT]
				add		r1, r1, #1
				strb	r1, [r0, #ICTXCB_INTCNT]
				b		return_int								; 


				END


;  end of file
