/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kswi_ctx.c
 * @brief %jp{ƥ}%en{context control}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/** %jp{¹ԥƥȤ} */
void _kernel_swi_ctx(
		_KERNEL_T_CTXCB *ctxcb_now,		/* ߤΥƥȤ¸ */
		_KERNEL_T_CTXCB *ctxcb_nxt)		/* ˼¹Ԥ륳ƥ */
{
	/* %jp{ڤؤ̵ʤ餽Τޤ} */
	if ( ctxcb_now == ctxcb_nxt )
	{
		return;
	}
	
	/* %jp{ƥ륻} */
	EnterCriticalSection(&_kernel_ictxcb.CriticalSection);
	
	/* %jp{¹楳ƥȤϿ} */
	_kernel_ictxcb.runctxcb = ctxcb_nxt;
	
	/* ڤؤ襳ƥȤγ */
	if ( ctxcb_nxt->blInterrupt )
	{
		SetEvent(ctxcb_nxt->hIntEvent);
	}
	else
	{
		SetEvent(ctxcb_nxt->hEvent);
	}
	
	/* ڤؤԤ */
	if ( ctxcb_now->blInterrupt )
	{
		/* %jp{ƥ륻Ф} */
		LeaveCriticalSection(&_kernel_ictxcb.CriticalSection);

		WaitForSingleObject(ctxcb_now->hIntEvent, INFINITE);
	}
	else
	{
		/* %jp{ƥ륻Ф} */
		LeaveCriticalSection(&_kernel_ictxcb.CriticalSection);

		WaitForSingleObject(ctxcb_now->hEvent, INFINITE);
	}
}	



/* end of file */
