/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  vsig_int.c
 * @brief %jp{ƥ}%en{context control}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/* %jp{ѽ} */
void vsig_int(int inhno)
{
	/* %jp{ѥޥե} */
	WaitForSingleObject(_kernel_ictxcb.hSemIntLock, INFINITE);
	
	/* %jp{ƥ륻} */
	EnterCriticalSection(&_kernel_ictxcb.CriticalSection);

	/* %jp{߾֤} */
	_kernel_ictxcb.inhno = inhno;

	/* %jp{߼¹ΥƥȤߥ⡼ɤ˰ܹ} */
	SuspendThread(_kernel_ictxcb.runctxcb->hThread);
	_kernel_ictxcb.runctxcb->blInterrupt = TRUE;
	SetEvent(_kernel_ictxcb.runctxcb->hIntEvent);
	
	/* %jp{ƥ륻Ф} */
	LeaveCriticalSection(&_kernel_ictxcb.CriticalSection);
}



/* end of file */
