; ---------------------------------------------------------------------------
;  HOS-V4 Advance
;     Intel 8086 LSI-C86 Small Model
;
;                                     Copyright (C) 1998-2006 by Project HOS
;                                     http://sourceforge.jp/projects/hos/
; ---------------------------------------------------------------------------


TEXT			CSEG


; -----------------------------------------------
;  %jp{߶ػ}
;  void _kernel_dis_int(void)
; -----------------------------------------------
_kernel_dis_int_::
				cli					; ߶ػ
				ret


; -----------------------------------------------
;  %jp{ߵ}
;  void _kernel_ena_int(void)
; -----------------------------------------------
_kernel_ena_int_::
				sti					; ߵ
				ret


; -----------------------------------------------
;  Entry point
; -----------------------------------------------
ctx_entry:		
				mov		ax, dx		; ¹Իѥ᡼1
				mov		bx, bp		; ¹Իѥ᡼2
				jmp		cx			; ¹ԥɥ쥹ʬ

; -----------------------------------------------
;  %jp{¹ԥƥȤκ}
;  _kernel_cre_ctx(
;		_KERNEL_T_CTXCB *pk_ctxcb,		륳ƥ (ax)
;		VP              isp,			åݥ (bx)
;		FP              entry,			¹ԥɥ쥹         (cx)
;		VP_INT          par1,			¹Իѥ᡼1    (dx)
;		VP_INT          par2)			¹Իѥ᡼2    ([sp+2].w)
; -----------------------------------------------
_kernel_cre_ctx_::
				sub		bx, 12
				mov		[bx], cx				; ¹ԥɥ쥹      [cx]
				mov		[bx+2], dx				; ¹Իѥ᡼1 [dx]
				mov		dx, [sp+2]
				mov		[bx+4], dx				; ¹Իѥ᡼2 [bp]
				mov		[bx+10].w, ctx_entry	; ꥿󥢥ɥ쥹
				xchg	ax, bx
				mov		[bx], ax
				ret


; -----------------------------------------------
;  %jp{¹ԥƥȤ}
;  void _kernel_swi_ctx(
;		_KERNEL_T_CTXCB *pk_ctxcb_nxt,			ڤؤΥƥ [ax]
;		_KERNEL_T_CTXCB *pk_ctxcb_now)			ߤΥƥ       [bx]
; -----------------------------------------------
_kernel_swi_ctx_::
				push	di
				push	si
				push	bp
				push	dx
				push	cx
				mov		[bx], sp
		; ---- Τޤ _kernel_sta_ctx ³

; -----------------------------------------------
;  %jp{¹ԥƥȤγ}
;  void _kernel_sta_ctx(
;		_KERNEL_T_CTXCB *pk_ctxcb)				Ϥ륳ƥ [ax]
; -----------------------------------------------
_kernel_sta_ctx_::
				mov		bx, ax
				mov		sp, [bx]
				pop		cx
				pop		dx
				pop		bp
				pop		si
				pop		di
				ret


; end of file
