/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp_sta.c
 * @brief %jp{ε}%en{Wakeup Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{򥵥ڥɲ} */
void _kernel_dsp_rsm_tsk(_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR     tcb;
	_KERNEL_TSK_T_TSKSTAT tskstat;

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{ߤξ֤} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
	
	/* %jp{ߤξ֤} */
	if ( !(tskstat & _KERNEL_TTS_WAI) )
	{
		/* %jp{ǥ塼³} */
		_KERNEL_SYS_ADD_RDQ(tskhdl);
	}
	
	/* %jp{Ԥ֤} */
	tskstat &= ~_KERNEL_TTS_SUS;
	_KERNEL_TSK_SET_TSKSTAT(tcb, tskstat);
}



/* end of file */
