/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp_wup.c
 * @brief %jp{򵯤}%en{Wakeup Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{򵯤}%en{Wakeup Task}
 * @param  tskhdl   %jp{оݤΥϥɥ}%en{Handle of the task to be woken up}
 * @retval void
 */
void _kernel_dsp_wup_tsk(_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR     tcb;
	_KERNEL_TSK_T_TSKSTAT tskstat;
	
	/* %jp{TCB}%en{get TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{ߤξ֤}%en{get current state} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
	
#if _KERNEL_SPT_SUS_TSK	&& (_KERNEL_TMAX_SUSCNT > 0)	/* %jp{ڥɤΥǥξ}%en{Supported suspend mode} */
	if ( !(tskstat & _KERNEL_TTS_SUS) )
	{
		/* %jp{ǥ塼³}%en{add to ready-queue} */
		_KERNEL_SYS_ADD_RDQ(tskhdl);
		tskstat = _KERNEL_TTS_RDY;
	}
	else
	{
		tskstat = _KERNEL_TTS_SUS;
	}
#else
	/* %jp{ǥ塼³}%en{add to ready-queue} */
	_KERNEL_ADD_RDQ(tskhdl);
	tskstat = _KERNEL_TTS_RDY;
#endif
	
	/* %jp{Ԥ֤}%en{set new state} */
	_KERNEL_TSK_SET_TSKSTAT(tcb, tskstat);
}



/* end of file */
