/**
 *  Hyper Operating System V4 Advance
 *
 * @file  hep.h
 * @brief %jp{ҡ}%en{create memory heap}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/hep.h"



/** %jp{ҡפ} */
void _kernel_cre_hep(
		_KERNEL_T_HEPCB *pk_hepcb,
		SIZE           hepsz,
		VP             hep)
{
	_KERNEL_T_HEPBLK *blk_last;
	
	/* %jp{Υ饤ȤĴ} */
	hepsz &= ~(_KERNEL_HEP_MEMALIGN - 1);

	/* %jp{å} */
	if ( hepsz <= sizeof(_KERNEL_T_HEPBLK) )
	{
		pk_hepcb->base = NULL;
		return;
	}

	/* %jp{¸} */
	pk_hepcb->base   = (_KERNEL_T_HEPBLK *)hep;
	pk_hepcb->heapsz = hepsz;
	
	/* %jp{üֿ֤ͤ} */
	blk_last = (_KERNEL_T_HEPBLK *)((UB *)hep + hepsz - _KERNEL_HEP_BLKSIZE);
	
	/* %jp{Τΰ} */
	pk_hepcb->base->prev = NULL;
	pk_hepcb->base->size = hepsz - (_KERNEL_HEP_BLKSIZE * 2);
	pk_hepcb->base->flag = _KERNEL_HEP_FREE;
	
	/* %jp{üֿͤ} */
	blk_last->prev = NULL;
	blk_last->size = 0;
	blk_last->flag = _KERNEL_HEP_USING;
}



/* end of file */
