/**
 *  Hyper Operating System V4 Advance
 *
 * @file  alc_hep.c
 * @brief %jp{ҡפإֵ}%en{memory free}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/hep.h"



/** %jp{β} */
void _kernel_fre_hep(
		_KERNEL_T_HEPCB *pk_hepcb,
		VP             ptr)
{
	_KERNEL_T_HEPBLK *mblk;
	_KERNEL_T_HEPBLK *mblktmp;
	_KERNEL_T_HEPBLK *mblknext;

	/* %jp{ݥϰϥå} */
	if ( ptr < (VP)pk_hepcb->base || ptr >= (VP)((UB*)pk_hepcb->base + pk_hepcb->heapsz) )
	{
		return;
	}

	/* %jp{֥å֤} */
	mblk = (_KERNEL_T_HEPBLK *)((UB *)ptr - _KERNEL_HEP_BLKSIZE);

	/* %jp{ѥ᡼å} */
	if ( mblk->flag != _KERNEL_HEP_USING )	/* %jp{̵} */
	{
		return;
	}

	/* %jp{ե饰̤Ѥ} */
	mblk->flag = _KERNEL_HEP_FREE;
	
	/* %jp{Υ֥åå} */
	mblktmp = (_KERNEL_T_HEPBLK *)((UB *)ptr + mblk->size);
	if ( mblktmp->flag == _KERNEL_HEP_FREE )
	{
		/* %jp{Υ֥å̤Ѥʤ礹} */
		mblknext = (_KERNEL_T_HEPBLK *)((UB *)mblktmp + mblktmp->size + _KERNEL_HEP_BLKSIZE);
		mblknext->prev = mblk;
		mblk->size += mblktmp->size + _KERNEL_HEP_BLKSIZE;
	}

	/* %jp{Υ֥åå} */
	if ( mblk->prev != NULL )
	{
		mblktmp = mblk->prev;
		if ( mblktmp->flag == _KERNEL_HEP_FREE )
		{
			/* %jp{Υ֥å̤Ѥʤ礹} */
			mblknext = (_KERNEL_T_HEPBLK *)((UB *)mblk + mblk->size + _KERNEL_HEP_BLKSIZE);
			mblknext->prev = mblktmp;
			mblktmp->size += mblk->size + _KERNEL_HEP_BLKSIZE;
		}
	}
}



/* end of file */
