/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_que.c
 * @brief %en{Add the task to the queue-tail}%jp{򥭥塼ɲ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/** %jp{򥭥塼ɲ}%en{Add the task to the queue-tail}
 * @param  que   %jp{ɲä륭塼}%en{pointer of queue}
 * @param  ptr   %jp{ɲä륿}%en{pointer of task}
 * @param  atr   %jp{ɲû°}%en{attribute}
 * @return void
 */
void _kernel_add_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl,
		ATR              atr)
{
	if ( atr & TA_TPRI )
	{
		_kernel_adp_que(pk_que, tskhdl);	/* %jp{ͥٽɲ}%en{in the order of task's priority}  */
	}
	else
	{
		_kernel_adf_que(pk_que, tskhdl);	/* %jp{FIFOɲ}%en{in the order of FIFO} */
	}
}



/* end of file */
