/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  adf_que.h
 * @brief %en{Add the task to queue in order of FIFO}%jp{FIFOǥ塼˥ɲ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_ONEWAYLIST		/* %en{One-way list} %jp{ñꥹ} */


/** %en{Add the task to queue in order of FIFO}%jp{FIFOǥ塼˥ɲ}
 * @param	que   %en{pointer of queue}%jp{ɲä륭塼}
 * @param	ptr   %en{pointer of task}%jp{ɲä륿}
 * @return	void
 */
void _kernel_adf_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TSKHDL tskhdl_tail;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_tail;

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{˽°塼} */
	_KERNEL_TSK_SET_QUE(tcb, pk_que);

	/* %jp{塼Υ} */
	tskhdl_tail = _KERNEL_QUE_GET_TAIL(pk_que);

	if ( tskhdl_tail == _KERNEL_TSKHDL_NULL )	/* queue is empty */
	{
		_KERNEL_TSK_SET_QUENEXT(tcb, tskhdl);
	}
	else	/* queue is not empty */
	{
		tcb_tail = _KERNEL_TSK_TSKHDL2TCB(tskhdl_tail);
		_KERNEL_TSK_SET_QUENEXT(tcb, _KERNEL_TSK_GET_QUENEXT(tcb_tail));
		_KERNEL_TSK_SET_QUENEXT(tcb_tail, tskhdl);
	}
	_KERNEL_QUE_SET_TAIL(pk_que, tskhdl);
}


#elif _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_TWOWAYLIST		/* %en{Two-way list} %jp{ꥹ} */


/** %en{Add the task to queue in order of FIFO}%jp{FIFOǥ塼˥ɲ}
 * @param	que   %en{pointer of queue}%jp{ɲä륭塼}
 * @param	ptr   %en{pointer of task}%jp{ɲä륿}
 * @return	void
 */
void _kernel_adf_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TSKHDL tskhdl_head;
	_KERNEL_T_TSKHDL tskhdl_tail;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_head;
	_KERNEL_T_TCB    *tcb_tail;
	
	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{˽°塼} */
	_KERNEL_TSK_SET_QUE(tcb, pk_que);

	/* %jp{塼ƬΥ} */
	tskhdl_head = _KERNEL_QUE_GET_HEAD(pk_que);

	if ( tskhdl_head == _KERNEL_TSKHDL_NULL )	/* queue is empty */
	{
		/* %jp{塼˥̵Ƭ} */
		_KERNEL_QUE_SET_HEAD(pk_que, tskhdl);
		_KERNEL_TSK_SET_QUENEXT(tcb, tskhdl);
		_KERNEL_TSK_SET_QUEPREV(tcb, tskhdl);
	}
	else	/* queue is not empty */
	{
		/* %jp{塼ɲ} */
		tcb_head    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_head);
		tskhdl_tail = _KERNEL_TSK_GET_QUEPREV(tcb_head);
		tcb_tail    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_tail);
		_KERNEL_TSK_SET_QUENEXT(tcb, tskhdl_head);
		_KERNEL_TSK_SET_QUEPREV(tcb, tskhdl_tail);
		_KERNEL_TSK_SET_QUENEXT(tcb_tail, tskhdl);
		_KERNEL_TSK_SET_QUEPREV(tcb_head, tskhdl);
	}
}


#endif



/* end of file */
