/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rmh_que.h
 * @brief %jp{塼ƬμФ}%en{}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_ONEWAYLIST		/* %en{One-way list} %jp{ñꥹ} */


/** %jp{塼μΥμФ}%en{}
 * @param	pk_que  %jp{Ф塼}%en{queue}
 * @return	%jp{Υ֤ξ _KERNEL_TSKHDL_NULL ֤}
 */
_KERNEL_T_TSKHDL _kernel_nxt_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	/** %jp{ʤNULL֤} */
	if ( tskhdl == _KERNEL_QUE_GET_TAIL(pk_que) )
	{
		return _KERNEL_TSKHDL_NULL;
	}

	/** %jp{Υ֤} */
	return _KERNEL_TSK_GET_QUENEXT(_KERNEL_TSK_TSKHDL2TCB(tskhdl));
}


#elif _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_TWOWAYLIST		/* %en{Two-way list} %jp{ꥹ} */



/** %jp{塼μΥμФ}%en{}
 * @param	pk_que  %jp{Ф塼}%en{queue}
 * @return	%jp{Υ֤ξ _KERNEL_TSKHDL_NULL ֤}
 */
_KERNEL_T_TSKHDL _kernel_nxt_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TCB    *tcb;
	
	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/** %jp{Υ} */
	tskhdl_next = _KERNEL_TSK_GET_QUENEXT(tcb);

	/** %jp{ʤNULL֤} */
	if ( tskhdl_next == _KERNEL_QUE_GET_HEAD(pk_que) )
	{
		return _KERNEL_TSKHDL_NULL;
	}

	/** %jp{Υ֤} */
	return tskhdl_next;
}


#endif



/* end of file */
