/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_rdq.c
 * @brief %jp{ǥ塼ɲ}%en{Add the task to the ready-queue}
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


#if _KERNEL_RDQ_ALGORITHM == _KERNEL_RDQ_ALG_ARRAYED_QUE

/** %jp{ǥ塼ɲ}%en{Add the task to the ready-queue}
 * @param  rdqcb  %jp{ɲäǥ塼}%en{pointer of ready-queue}
 * @param  tskhdl %jp{ɲä륿Υϥɥ}%en{handle of task}
 * @return void
 */
void _kernel_add_rdq(_KERNEL_T_RDQCB *rdqcb, _KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR	tcb;
	PRI					tskpri;

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{ͥ٤} */
	tskpri = _KERNEL_TSK_GET_TSKPRI(tcb);
	
	/* %jp{塼ɲ} */
	_KERNEL_ADP_QUE(&rdqcb->que[tskpri-1], tskhdl);
}


#endif	/* _KERNEL_RDQ_ALGORITHM */



/* end of file */
