/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_tmq.c
 * @brief %jp{ޥ塼˥֥Ȥɲ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "core/tmq.h"



/* ޥ֥ȤꥹȤ */
void _kernel_rmv_tmq(
		_KERNEL_T_TMQCB  *tmqcb,
		_KERNEL_T_TIMOBJ *pk_timobj)
{
	/* %jp{̤Ͽʤ鲿⤷ʤ} */
	if ( pk_timobj->next == NULL )
	{
		return;
	}
	
	/* %jp{楪֥ȤθƤӽФʤ} */
	if ( pk_timobj == tmqcb->busy )
	{
		tmqcb->busy = NULL;
	}
	
	/* %jp{Υޤʤݥ󥿤򤺤餹} */
	if ( pk_timobj == tmqcb->next )
	{
		tmqcb->next = pk_timobj->next;		/* %jp{Υ֥Ȥ˰ư} */
	}
	
	/* %jp{ꥹȤ} */
	if ( pk_timobj == pk_timobj->next )
	{
		/* %jp{ꥹȤˤʤ} */
		tmqcb->head = NULL;
		tmqcb->next = NULL;
	}
	else
	{
		/* %jp{ƬʤƬ֤򤺤餹} */
		if ( pk_timobj == tmqcb->head )
		{
			tmqcb->head = pk_timobj->next;
		}
		
		/* %jp{ꥹȤ} */
		pk_timobj->next->prev = pk_timobj->prev;
		pk_timobj->prev->next = pk_timobj->next;
	}
	
	/* %jp{̤Ͽ} */
	pk_timobj->next = NULL;
}


/* end of file */
