/**
 *  Hyper Operating System V4 Advance
 *
 * @file  rmv_toq.c
 * @brief %jp{򥿥ॢȥ塼}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_TOQ

/* ॢԤ󤫤饿 */
void _kernel_rmv_toq(
		_KERNEL_T_TOQCB  *toqcb,
		_KERNEL_T_TSKHDL tskhdl)	/* Ԥ󤫤륿 */
{
	_KERNEL_T_TSKHDL tskhdl_prev;
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_prev;
	_KERNEL_T_TCB    *tcb_next;

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	tskhdl_prev = _KERNEL_TSK_GET_TOQPREV(tcb);

	/* ॢȥ塼̤³ʤ̵ */
	if ( tskhdl_prev == _KERNEL_TSKHDL_NULL )
	{
		return;
	}
	
	/* 塼κǸΣĥʤ */
	if ( tskhdl_prev == tskhdl )
	{
		_KERNEL_TOQ_SET_HEAD(toqcb, _KERNEL_TSKHDL_NULL);		/* ॢȥ塼ˤ */
	}
	else
	{
		tskhdl_next = _KERNEL_TSK_GET_TOQNEXT(tcb);
		tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
		tskhdl_prev = _KERNEL_TSK_GET_TOQPREV(tcb);
		tcb_prev    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_prev);

		/* Ǥʤ */
		if ( tskhdl_next != _KERNEL_TOQ_GET_HEAD(toqcb) )
		{
			/* ֺʬ */
			_KERNEL_TSK_SET_TOQDIFTIM(tcb_next, _KERNEL_TSK_GET_TOQDIFTIM(tcb_next) + _KERNEL_TSK_GET_TOQDIFTIM(tcb));
		}
		
		/* Ƭʤ */
		if ( tskhdl == _KERNEL_TOQ_GET_HEAD(toqcb) )
		{
			_KERNEL_TOQ_SET_HEAD(toqcb, tskhdl_next);	/* Ƭֹ */
		}
		
		/* 塼鳰 */
		_KERNEL_TSK_SET_TOQNEXT(tcb_prev, tskhdl_next);
		_KERNEL_TSK_SET_TOQPREV(tcb_next, tskhdl_prev);
	}
	
	/* ̤³ */
	_KERNEL_TSK_SET_TOQPREV(tcb, _KERNEL_TSKHDL_NULL);
}

#endif	/* _KERNEL_SPT_TOQ */


/* end of file */
