/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_dtq.c
 * @brief %jp{ǡ塼(IDֹ漫ưդ)}%en{Create Data queue(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/dtqobj.h"



#if _KERNEL_SPT_ACRE_DTQ

/** %jp{ǡ塼(IDֹ漫ưդ)}%en{Create Data queue(ID Number Automatic Assignment)}
 * @param  pk_cdtq	      %jp{ǡ塼줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the data queue creation information}
 * @retval %jp{}%en{positiv-value} %jp{ǡ塼IDֹ}%en{ID number of the created data queue}
 * @retval E_NOID  %jp{IDֹ­(ղǽʥǡ塼ID̵)}%en{No ID number available(there id no data queue ID assignable)}
 * @retval E_RSATR %jp{ͽ°(dtqatr뤤ϻѤǤʤ)}%en{Reserved attribute(dtqatr is invalid or unusable)}
 */
ER_ID acre_dtq(const T_CDTQ *pk_cdtq)
{
	ID    dtqid;
	ER_ID erid;

	/* %jp{°å}%en{check attribute} */
#if _KERNEL_SPT_ACRE_DTQ_E_RSATR
	if ( ((pk_cdtq->dtqatr & TA_TPRI) == 0 && !_KERNEL_SPT_DTQ_TA_TFIFO)
		|| ((pk_cdtq->dtqatr & TA_TPRI) != 0 && !_KERNEL_SPT_DTQ_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{ͽ°}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{IDõ} */
	for ( dtqid = _KERNEL_DTQ_TMAX_ID; dtqid >= _KERNEL_DTQ_TMIN_ID; dtqid-- )
	{
		if ( !_KERNEL_DTQ_CHECK_EXS(dtqid) )
		{
			break;
		}
	}

	/* %jp{IDõå} */
#if _KERNEL_SPT_ACRE_DTQ_E_NOID
	if ( dtqid < _KERNEL_DTQ_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOID;			/* %jp{IDֹ­} */
	}
#endif
	
	/* %jp{֥} */
#if (_KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_DTQ_E_NOMEM
	erid = (ER_ID)_kernel_cre_dtq(dtqid, pk_cdtq);
	if ( erid == E_OK )
	{
		erid = (ER_ID)dtqid;	/* %jp{顼ǤʤХǡ塼IDǼ} */
	}
#else
	_kernel_cre_dtq(dtqid, pk_cdtq);
	erid = (ER_ID)dtqid;		/* %jp{ǡ塼IDǼ} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_DTQ */


#if _KERNEL_SPT_ACRE_DTQ_E_NOSPT


/** %jp{ǡ塼(IDֹ漫ưդ)}%en{Create Data queue(ID Number Automatic Assignment)}
 * @param  pk_cdtq  %jp{ǡ塼줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the data queue creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER_ID acre_dtq(const T_CDTQ *pk_cdtq)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_DTQ */



/* end of file */
