/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_dtq.c
 * @brief %jp{ǡ塼}%en{Create Data queue}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/dtqobj.h"



#if _KERNEL_SPT_CRE_DTQ


/** %jp{ǡ塼}%en{Create Data queue}
 * @param  dtqid    %jp{оݤΥǡ塼IDֹ}%en{ID number of the data queue to be created}
 * @param  pk_ctsk	%jp{ǡ塼줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the data queue creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(dtqid뤤ϻѤǤʤ)}%en{Invalid ID number(dtqid is invalid or unusable)}
 * @retval E_RSATR  %jp{ͽ°(dtqatr뤤ϻѤǤʤ)}%en{Reserved attribute(dtqatr is invalid or unusable)}
 * @retval E_OBJ    %jp{֥Ⱦ֥顼(оݥǡ塼ϿѤ)}%en{Object state error(specified data queue is already registerd)}
 */
ER cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq)
{
	ER ercd;

	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_CRE_DTQ_E_ID
	if ( !_KERNEL_DTQ_CHECK_DTQID(dtqid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif

	/* %jp{°å}%en{check attribute} */
#if _KERNEL_SPT_CRE_DTQ_E_RSATR
	if ( ((pk_cdtq->dtqatr & TA_TPRI) == 0 && !_KERNEL_SPT_DTQ_TA_TFIFO)
		|| ((pk_cdtq->dtqatr & TA_TPRI) != 0 && !_KERNEL_SPT_DTQ_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{ͽ°}%en{Reserved attribute} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_CRE_DTQ_E_OBJ
	if ( _KERNEL_DTQ_CHECK_EXS(dtqid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_OBJ;			/* %jp{֥Ⱦ֥顼}%en{Object state error} */
	}
#endif
	
	/* %jp{֥}%en{create object} */
	ercd = _kernel_cre_dtq(dtqid, pk_cdtq);
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_CRE_DTQ */


#if _KERNEL_SPT_CRE_DTQ_E_NOSPT

/** %jp{ǡ塼}%en{Create Data queue}
 * @param  dtqid    %jp{оݤΥǡ塼IDֹ}%en{ID number of the data queue to be created}
 * @param  pk_ctsk	%jp{ǡ塼줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the data queue creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_DTQ */



/* end of file */
