/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  prcv_dtq.c
 * @brief %jp{ǡ塼ؤ(ݡ)}%en{Send to Data Queue(Polling)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/dtqobj.h"



#if _KERNEL_SPT_PRCV_DTQ


/** %jp{ǡ塼ؤ(ݡ)}%en{Send to Data Queue(Polling)} */
ER prcv_dtq(ID dtqid, VP_INT *p_data)
{
	_KERNEL_T_DTQCB				*dtqcb;
	const _KERNEL_T_DTQCB_RO	*dtqcb_ro;
	_KERNEL_T_TSKHDL			tskhdl;
	_KERNEL_T_TCB				*tcb;
	_KERNEL_DTQ_T_DTQCNT		sdtqcnt;
	ER							ercd;


	/* %jp{ƥȥå} */
#if _KERNEL_SPT_PRCV_DTQ_E_CTX
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		return E_CTX;			/* %jp{ƥȥ顼}%en{Context error} */
	}
#endif

	/* %jp{ID Υå} */
#if _KERNEL_SPT_PRCV_DTQ_E_ID
	if ( !_KERNEL_DTQ_CHECK_DTQID(dtqid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif

	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_PRCV_DTQ_E_NOEXS
	if ( !_KERNEL_DTQ_CHECK_EXS(dtqid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
		return E_NOEXS;			/* %jp{֥̤} */
	}
#endif
	
	/* %jp{ǡ塼ȥ֥å} */
	dtqcb = _KERNEL_DTQ_ID2DTQCB(dtqid);
	
	/* %jp{ԤƬ饿Ф} */
	tskhdl = _KERNEL_DTQ_RMH_SQUE(dtqcb);
	if ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ԤԤ} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
		
		/* %jp{򵯤} */
		_KERNEL_TSK_SET_ERCD(tcb, E_OK);	/* %jp{顼} */
		_KERNEL_DSP_WUP_TSK(tskhdl);		/* %jp{Ԥ} */
		_KERNEL_DTQ_RMV_STOQ(tskhdl);		/* %jp{ॢȥ塼Ϥ} */
	}
	
	
#if _KERNEL_SPT_DTQ_DTQCNT_NONZERO		/* %jp{ǡ塼} */
	sdtqcnt = _KERNEL_DTQ_GET_SDTQCNT(dtqcb);
	if ( sdtqcnt > 0 )		/* %jp{塼˥ǡϤ뤫} */
	{
		_KERNEL_DTQ_T_DTQCNT		dtqcnt;
		VP_INT						*dtq;
		_KERNEL_DTQ_T_DTQCNT		head;
		
		/* %jp{RO} */
		dtqcb_ro = _KERNEL_DTQ_GET_DTQCB_RO(dtqid, dtqcb);
		
		/* %jp{ǡ塼} */
		dtq = _KERNEL_DTQ_GET_DTQ(dtqcb_ro);
		
		/* %jp{塼ǡФ} */
		head   = _KERNEL_DTQ_GET_HEAD(dtqcb);
		dtqcnt = _KERNEL_DTQ_GET_DTQCNT(dtqcb_ro);
		*p_data = dtq[head];
		
		/* %jp{ԤХǡɲ} */
		if ( tskhdl != _KERNEL_TSKHDL_NULL )
		{
			/* %jp{ǡǼ} */
			tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
			dtq[head] = (VP_INT)_KERNEL_TSK_GET_DATA(tcb);
		}
		else
		{
			/* %jp{Ԥ̵Х塼ΥǡĿ򸺤} */
			sdtqcnt--;
			_KERNEL_DTQ_SET_SDTQCNT(dtqcb, sdtqcnt);
		}
		
		/* %jp{Ƭ֤򤺤餹} */
		if ( head + 1 < dtqcnt )
		{
			head++;
		}
		else
		{
			head = 0;
		}
		_KERNEL_DTQ_SET_HEAD(dtqcb, head);

		if ( tskhdl != _KERNEL_TSKHDL_NULL )
		{
			/* %jp{ǥѥåμ¹} */
			_KERNEL_DSP_TSK();
		}
		
		ercd = E_OK;	/* %jp{ｪλ}%en{Normal completion} */
	}
	else
#endif
	{
#if _KERNEL_SPT_DTQ_DTQCNT_ZERO
		if ( tskhdl != _KERNEL_TSKHDL_NULL )
		{
			/* %jp{ǡ} */
			tcb     = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
			*p_data = (VP_INT)_KERNEL_TSK_GET_DATA(tcb);	/* %jp{ǡǼ} */

			/* %jp{ǥѥåμ¹} */
			_KERNEL_DSP_TSK();

			ercd = E_OK;		/* %jp{ｪλ}%en{Normal completion} */
		}
		else
#endif
		{
			ercd = E_TMOUT;		/* %jp{ॢ} */
		}		
	}
		
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_PRCV_DTQ */


#if _KERNEL_SPT_PRCV_DTQ_E_NOSPT

/** %jp{ǡ塼ؤ(ݡ)}%en{Send to Data Queue(Polling)} */
ER prcv_dtq(ID dtqid, VP_INT data)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_PRCV_DTQ */



/* end of file */
