/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  clr_flg.c
 * @brief %jp{٥ȥե饰Υꥢ}%en{Clear Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_CLR_FLG


/** %jp{٥ȥե饰Υꥢ}%en{Clear Eventflag}
 * @param  flgid    %jp{ꥢоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be cleared}
 * @param  clrptn   %jp{ꥢӥåȥѥ(ӥåȤȤȿž)}%en{Bit pattern to clear(bit-wise negated)}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(setptn)}%en{Parameter error(setptn is invalid)}
 */
ER clr_flg(ID flgid, FLGPTN clrptn)
{
	_KERNEL_T_FLGCB *flgcb;
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_CLR_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{ID} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ볫} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_CLR_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
		return E_NOEXS;			/* %jp{֥̤} */
	}
#endif
	
	/* %jp{ȥ֥å} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);
	
	/* ե饰ꥢ */
	_KERNEL_FLG_SET_FLGPTN(flgcb, _KERNEL_FLG_GET_FLGPTN(flgcb) & clrptn);

	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
	
	return E_OK;	/* %jp{} */
}


#else	/* _KERNEL_SPT_CLR_FLG */


#if _KERNEL_SPT_CLR_FLG_E_NOSPT

/** %jp{٥ȥե饰Υꥢ}%en{Clear Eventflag}
 * @param  flgid    %jp{ꥢоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be cleared}
 * @param  clrptn   %jp{ꥢӥåȥѥ(ӥåȤȤȿž)}%en{Bit pattern to clear(bit-wise negated)}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER clr_flg(ID flgid, FLGPTN clrptn)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CLR_FLG */


/* end of file */
