/**
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_flg.c
 * @brief %jp{٥ȥե饰}%en{Create Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_CRE_FLG


/** %jp{٥ȥե饰}%en{Create Eventflag}
 * @param  flgid    %jp{оݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be created}
 * @param  pk_cflg	%jp{٥ȥե饰줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the eventflag creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(semid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_RSATR  %jp{ͽ°(flgatr뤤ϻѤǤʤ)}%en{Reserved attribute(flgatr is invalid or unusable)}
 * @retval E_OBJ    %jp{֥Ⱦ֥顼(оݥ٥ȥե饰ϿѤ)}%en{Object state error(specified eventflag is already registerd)}
 */
ER cre_flg(ID flgid, const T_CFLG *pk_cflg)
{
	ER ercd;

	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_CRE_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif

	/* %jp{°å}%en{check attribute} */
#if _KERNEL_SPT_ACRE_FLG_E_RSATR
	if ( ((pk_cflg->flgatr & TA_TPRI) == 0 && !_KERNEL_SPT_FLG_TA_TFIFO)
		|| ((pk_cflg->flgatr & TA_TPRI) != 0 && !_KERNEL_SPT_FLG_TA_TPRI)
		|| ((pk_cflg->flgatr & TA_WMUL) == 0 && !_KERNEL_SPT_FLG_TA_WSGL)
		|| ((pk_cflg->flgatr & TA_WMUL) != 0 && !_KERNEL_SPT_FLG_TA_WMUL)
		|| ((pk_cflg->flgatr & TA_CLR)  != 0 && !_KERNEL_SPT_FLG_TA_CLR) )
	{
		return E_RSATR;	/* %jp{ͽ°}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_CRE_FLG_E_OBJ
	if ( _KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_OBJ;			/* %jp{֥Ⱦ֥顼}%en{Object state error} */
	}
#endif
	
	/* %jp{٥ȥե饰} */
	ercd = _kernel_cre_flg(flgid, pk_cflg);

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_CRE_FLG */


#if _KERNEL_SPT_CRE_FLG_E_NOSPT

/** %jp{٥ȥե饰}%en{Create Eventflag}
 * @param  flgid    %jp{оݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be created}
 * @param  pk_cflg	%jp{٥ȥե饰줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the eventflag creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER cre_flg(const T_CFLG *pk_cflg)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_FLG */



/* end of file */
