/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  del_flg.c
 * @brief %jp{٥ȥե饰κ}%en{Delete Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_DEL_FLG


/** %jp{٥ȥե饰κ}%en{Delete Eventflag}
 * @param  flgid    %jp{оݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be deleted}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified eventflag is not registerd)}
 */
ER del_flg(ID flgid)
{
	_KERNEL_T_FLGCB  *flgcb;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_QUE    *pk_que;;

	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_DEL_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_DEL_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;	
	}
#endif
	
	/* %jp{ȥ֥å} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);
	
	/* %jp{Ԥ} */
	pk_que = _KERNEL_FLG_GET_QUE(flgcb);
	
	/* %jp{ԤΥƵ} */
	while ( (tskhdl = _KERNEL_RMH_QUE(pk_que)) != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ԤԤ} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);	/* %jp{TCB} */
		_KERNEL_TSK_SET_ERCD(tcb, E_DLT);		/* %jp{顼} */
		_KERNEL_FLG_RMV_TOQ(tskhdl);			/* %jp{ॢȥ塼鳰} */
		_KERNEL_DSP_WUP_TSK(tskhdl);			/* %jp{Ԥ} */	
	}
	
	/* %jp{֥Ⱥ} */
#if _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(_KERNEL_FLG_ID2FLGCB(flgid));	/* %jp{곫} */
	_KERNEL_FLG_ID2FLGCB(flgid) = NULL;
#elif _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_BLKARRAY
	_KERNEL_FLG_SET_FLGATR(flgcb, 0);					/* %jp{ޡ} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_FLG */


#if _KERNEL_SPT_DEL_FLG_E_NOSPT

/** %jp{٥ȥե饰κ}%en{Delete Eventflag}
 * @param  flgid    %jp{оݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be deleted}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER del_flg(ID flgid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_FLG */



/* end of file */
