/**
 *  Hyper Operating System V4 Advance
 *
 * @file  sig_sem.c
 * @brief %jp{ޥե񸻤ֵ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



/* %jp{ե饰Ƥ뤫å} */
BOOL _kernel_chk_flg(
		_KERNEL_T_FLGCB  *flgcb,		/* %jp{ȥ֥å} */
		_KERNEL_T_FLGINF *pk_flginf)	/* %jp{Ԥե饰ѥåȤƬ} */
{
	if ( pk_flginf->wfmode == TWF_ANDW )
	{
		/* %jp{ANDԤȽ} */
		return ((_KERNEL_FLG_GET_FLGPTN(flgcb) & pk_flginf->waiptn) == pk_flginf->waiptn);
	}
	else
	{
		/* %jp{ORԤȽ} */
		return ((_KERNEL_FLG_GET_FLGPTN(flgcb) & pk_flginf->waiptn) != 0);
	}
}


/* end of file */
