/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ref_flg.c
 * @brief %jp{٥ȥե饰ξֻ}%en{Reference Semaphore State}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_REF_FLG


/** %jp{٥ȥե饰ξֻ}%en{Reference Semaphore State}
 * @param  flgid    %jp{񸻳оݤΥ٥ȥե饰IDֹ}%en{ID number of the flgaphore from which resource is acquired}
 * @param  pk_rflg  %jp{٥ȥե饰֤֤ѥåȤؤΥݥ}%en{Pointer to the packet returning the flgaphore state}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified flgaphore is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(pk_rflg)}%en{Parameter error(pk_rflg is invalid)}
 */
ER ref_flg(ID flgid, T_RFLG *pk_rflg)
{
	_KERNEL_T_FLGCB *flgcb;
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_REF_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
#if _KERNEL_SPT_REF_FLG_E_PAR
	if ( pk_rflg == NULL )
	{
		return E_PAR;	/* %jp{ѥ᡼顼}%en{Parameter error} */
	}
#endif
		
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_REF_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;			/* %jp{֥̤}%en{Non-existant object} */
	}
#endif

	/* %jp{ȥ֥å} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);
	
	/* %jp{} */
	pk_rflg->wtskid = _KERNEL_TSK_GET_TSKID(_KERNEL_REF_QUE(_KERNEL_FLG_GET_QUE(flgcb)));
	pk_rflg->flgptn = _KERNEL_FLG_GET_FLGPTN(flgcb);
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_REF_FLG */


#if _KERNEL_SPT_REF_FLG_E_NOSPT

/** %jp{٥ȥե饰񸻤γ(ݡ)}%en{Acquire Semaphore Resource(Polling)}
 * @param  flgid    %jp{񸻳оݤΥ٥ȥե饰IDֹ}%en{ID number of the flgaphore from which resource is acquired}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER ref_flg(ID flgid, T_RFLG *pk_rflg)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_REF_FLG */



/* end of file */
